<?php

/**
 * Single Product Up-Sells
 *
 * Wrapper product up sells with swiper slider html
 *
 * @see         https://github.com/woocommerce/woocommerce/blob/trunk/plugins/woocommerce/templates/single-product/up-sells.php
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

defined( 'ABSPATH' ) || exit;

// Swiper options
$slider_options = htmlspecialchars(
	json_encode(
		array(
			'slidesPerView' => 2,
			'spaceBetween'  => 15,
			'itemWrapper'   => '.rt-product__thumbnail',
			'breakpoints'   => array(
				728 => array(
					'slidesPerView' => 4,
					'spaceBetween'  => 30,
				),
			),
		)
	)
);

$heading = apply_filters( 'woocommerce_product_upsells_products_heading', __( 'You may also like&hellip;', 'woocommerce' ) );
?>
<?php if ( ! empty( $upsells ) ) : ?>
	<div id="rt_products_up_sells" class="rt-product-up-sells">

		<?php if ( $heading ) : ?>
			<div class="rt-block-heading">
				<h2 class="rt-block-heading__title"><?php echo esc_html( $heading ); ?></h2>
			</div>
		<?php endif; ?>

		<div class="wp-block-group">
			<div class="rt-swiper is-swiper-pagination-outside products" style="--slides: 2; --gap: 30px; --slides-md: 4; --gap-md: 30px;">
				<div class="swiper js-swiper" data-options="<?php echo esc_attr( $slider_options ); ?>">
					<div class="swiper-wrapper">
						<?php foreach ( $upsells as $upsell ) : ?>
							<?php
							$post_object = get_post( $upsell->get_id() );
							setup_postdata( $GLOBALS['post'] = $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
							?>
							<div class="swiper-slide">
								<div class="rt-swiper-item"><?php wc_get_template_part( 'content', 'product' ); ?></div>
							</div>
						<?php endforeach; ?>
					</div>
					<div class="swiper-pagination mt-20">
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
					</div>
				</div>
				<div class="rt-swiper-navigation">
					<div class="swiper-button-prev"></div>
					<div class="swiper-button-next"></div>
				</div>
			</div>
		</div>
	</div>

<?php endif ?>

<?php wp_reset_postdata(); ?>