<?php

/**
 * Related Products
 *
 * Wrapper product related with swiper slider html
 *
 * @see         https://github.com/woocommerce/woocommerce/blob/trunk/plugins/woocommerce/templates/single-product/related.php
 * @package     WooCommerce\Templates
 * @version     10.3.0
 */

defined( 'ABSPATH' ) || exit;

// Swiper options
$slider_options = htmlspecialchars(
	json_encode(
		array(
			'slidesPerView' => 2,
			'spaceBetween'  => 15,
			'itemWrapper'   => '.rt-product__thumbnail',
			'breakpoints'   => array(
				728 => array(
					'slidesPerView' => 4,
					'spaceBetween'  => 30,
				),
			),
		)
	)
);

$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );
?>
<?php if ( ! empty( $related_products ) ) : ?>

	<?php

	/**
	 * Ensure all images of related products are lazy loaded by increasing the
	 * current media count to WordPress's lazy loading threshold if needed.
	 * Because wp_increase_content_media_count() is a private function, we
	 * check for its existence before use.
	 */
	if ( function_exists( 'wp_increase_content_media_count' ) ) {
		$content_media_count = wp_increase_content_media_count( 0 );
		if ( $content_media_count < wp_omit_loading_attr_threshold() ) {
			wp_increase_content_media_count( wp_omit_loading_attr_threshold() - $content_media_count );
		}
	}
	?>

	<div id="rt_products_related" class="rt-product-relateds">

		<?php if ( $heading ) : ?>
			<div class="rt-block-heading">
				<h2 class="rt-block-heading__title"><?php echo esc_html( $heading ); ?></h2>
			</div>
		<?php endif; ?>

		<div class="wp-block-group">
			<div class="rt-swiper is-swiper-pagination-outside products" style="--slides: 2; --gap: 30px; --slides-md: 4; --gap-md: 30px;">
				<div class="swiper js-swiper" data-options="<?php echo esc_attr( $slider_options ); ?>">
					<div class="swiper-wrapper">
						<?php foreach ( $related_products as $related_product ) : ?>
							<?php
							$post_object = get_post( $related_product->get_id() );
							setup_postdata( $GLOBALS['post'] = $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

							?>
							<div class="swiper-slide">
								<div class="rt-swiper-item"><?php wc_get_template_part( 'content', 'product' ); ?></div>
							</div>
						<?php endforeach; ?>
					</div>
					<div class="swiper-pagination mt-20">
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
					</div>
				</div>
				<div class="rt-swiper-navigation">
					<div class="swiper-button-prev"></div>
					<div class="swiper-button-next"></div>
				</div>
			</div>
		</div>
	</div>

<?php endif ?>

<?php wp_reset_postdata(); ?>