<?php

/**
 * Single Product Image
 *
 * @hook woocommerce_before_single_product_summary
 * @package Retheme\WooCommerce
 * @version 9.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$images              = array();
$featured_image_size = 'woocommerce_single';
$gallery_image_size  = 'woocommerce_thumbnail';
$image_caption       = true;

// Swiper options
$slider_options = array(
	'thumbnailSlides'       => 7,
	'thumbnailSlidesMobile' => 5,
);

// Get image featured attributes
$featured_image_id = has_post_thumbnail() ? $product->get_image_id() : get_option( 'woocommerce_placeholder_image' );
$images[]          = array(
	'id'    => $featured_image_id,
	'src'   => wp_get_attachment_image_url( $featured_image_id, 'large' ),
	'title' => get_the_title( $featured_image_id ),
	'class' => 'is-featured-image',
);

// Get gallery images attributes
$gallery_image_ids = $product->get_gallery_image_ids() ? $product->get_gallery_image_ids() : array();
foreach ( $gallery_image_ids as $gallery_image_id ) {
	$images[] = array(
		'id'    => $gallery_image_id,
		'src'   => wp_get_attachment_image_url( $gallery_image_id, 'large' ),
		'title' => get_the_title( $gallery_image_id ),
	);
}
?>

<?php if ( $images ) : ?>
	<div id="rt_product_gallery" class="rt-product-images rt-swiper-gallery images js-product-gallery" data-options="<?php echo esc_attr( json_encode( $slider_options ) ); ?>">

		<?php if ( ! empty( $images ) ) : ?>
			<div class="rt-swiper rt-swiper-gallery__featured" style="--slides:1; --gap:10px; --slides-md:1; --gap-md:10px;">
				<div class="swiper">
					<div class="swiper-wrapper">
						<?php foreach ( $images as $index => $image ) : ?>
							<?php $class = ! empty( $image['class'] ) ? $image['class'] : ''; ?>
							<div class="swiper-slide <?php echo esc_attr( $class ); ?>">
								<a href="<?php echo esc_url( $image['src'] ); ?>" class="js-glightbox" data-glightbox="gallery"
									data-gallery="gallery-<?php echo esc_attr( get_the_ID() ); ?>"
									data-title="<?php echo esc_attr( $image['title'] ); ?>">
									<div class="rt-img relative">

										<button class="rt-img__zoom" type="button" aria-label="<?php echo esc_attr__( 'Zoom in', 'kubelio' ); ?>">
											<i class="rt-icon">
												<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 84 84" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2">
													<path style="fill:none" d="M0 0h83.333v83.333H0z" />
													<path d="M75.972 59.294c0-1.335 1.092-2.433 2.419-2.433 1.328 0 2.42 1.098 2.42 2.433v19.337c0 1.334-1.092 2.432-2.42 2.432H59.156c-1.328 0-2.42-1.098-2.42-2.432 0-1.334 1.092-2.432 2.42-2.432h16.816V59.294Zm-68.402 0c0-1.335-1.092-2.433-2.419-2.433-1.328 0-2.42 1.098-2.42 2.433v19.337c0 1.334 1.092 2.432 2.42 2.432h19.235c1.328 0 2.42-1.098 2.42-2.432 0-1.334-1.092-2.432-2.42-2.432H7.57V59.294ZM76.016 23.99c0 1.335 1.092 2.433 2.419 2.433 1.328 0 2.42-1.098 2.42-2.433V4.653c0-1.335-1.092-2.433-2.42-2.433H59.2c-1.328 0-2.42 1.098-2.42 2.433 0 1.334 1.092 2.432 2.42 2.432h16.816V23.99Zm-68.402 0c0 1.335-1.092 2.433-2.419 2.433-1.328 0-2.42-1.098-2.42-2.433V4.653c0-1.335 1.092-2.433 2.42-2.433H24.43c1.328 0 2.42 1.098 2.42 2.433 0 1.334-1.092 2.432-2.42 2.432H7.614V23.99Z" />
												</svg>
											</i>
										</button>

										<?php echo wp_get_attachment_image( $image['id'], $featured_image_size, array( 'class' => $class ) ); ?>

										<?php if ( $image_caption && wp_get_attachment_caption( $image['id'] ) ) : ?>
											<div
												class="rt-img__description has-background-alt-background-color has-body-alt-color has-xx-small-font-size leading-md text-center py-10 px-10 md:py-20 md:px-20 absolute bottom-0 left-0 right-0">
												<div class="rt-img__caption line-clamp-3">
													<?php echo esc_html( wp_get_attachment_caption( $image['id'] ) ); ?>
												</div>
											</div>
										<?php endif; ?>

									</div>
								</a>
							</div>
						<?php endforeach; ?>
					</div>

					<div class="swiper-pagination">
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
						<span class="swiper-pagination-bullet"></span>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php if ( ! empty( $images ) && $gallery_image_ids ) : ?>
			<div class="rt-swiper rt-swiper-gallery__thumbnails" style="--slides: <?php echo esc_attr( $slider_options['thumbnailSlidesMobile'] ); ?>; --gap: 10px; --slides-md: <?php echo esc_attr( $slider_options['thumbnailSlides'] ); ?>; --gap-md: 10px; margin-top: 10px">
				<div class="swiper">
					<div class="swiper-wrapper pb-10">

						<?php $class = ! empty( $image['class'] ) ? $image['class'] : ''; ?>
						<?php foreach ( $images as $index => $image ) : ?>
							<div class="swiper-slide <?php echo esc_attr( $class ); ?>" data-index="<?php echo esc_attr( $index ); ?>">
								<div class="rt-img">
									<?php echo wp_get_attachment_image( $image['id'], $gallery_image_size, array( 'class' => $class ) ); ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>

	</div>
<?php endif; ?>