<?php
/**
 * Header Template for WooCommerce Catalog
 *
 * @package Retheme\WooCommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

$layout       = get_theme_mod( 'woocommerce_shop_layout', 'wide' );
$class_filter = $layout === 'sidebar' ? 'block md:hidden' : '';
$class_header = $layout !== 'sidebar-stack' ? 'flex flex-col-reverse md:flex-row md:items-center ' : 'is-layout-flex';
?>
<div class="rt-products-header has-x-small-font-size justify-between gap-20 <?php echo esc_attr( $class_header ); ?>">
	<div class="rt-products-header__result">
		<?php woocommerce_result_count(); ?>
	</div>

	<div class="wp-block-group flex items-center gap-10 md:gap-30 justify-between">
		<div class="rt-products-header__ordering">
			<?php woocommerce_catalog_ordering(); ?>
		</div>

		<?php if ( $layout !== 'sidebar-stack' ) : ?>
			<div class="rt-products-header__filter <?php echo esc_attr( $class_filter ); ?>">
				<a href="#offcanvas_widget_shop" class="js-slidepanel has-body-color" role="button"
					aria-label="<?php echo esc_attr__( 'Open Shop Filter', 'kubelio' ); ?>">
					<i class="rt-icon mr-10"> <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
							fill="currentColor" class="bi bi-sliders" viewBox="0 0 16 16">
							<path fill-rule="evenodd"
								d="M11.5 2a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3M9.05 3a2.5 2.5 0 0 1 4.9 0H16v1h-2.05a2.5 2.5 0 0 1-4.9 0H0V3zM4.5 7a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3M2.05 8a2.5 2.5 0 0 1 4.9 0H16v1H6.95a2.5 2.5 0 0 1-4.9 0H0V8zm9.45 4a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-2.45 1a2.5 2.5 0 0 1 4.9 0H16v1h-2.05a2.5 2.5 0 0 1-4.9 0H0v-1z" />
						</svg>
					</i>
					<span><?php echo esc_html__( 'Filters', 'kubelio' ); ?></span>
				</a>
			</div>
		<?php endif ?>

	</div>
</div>