<?php
/**
 * Filter Template for WooCommerce Catalog
 *
 * This template show sidebar filter.
 *
 * @package Retheme\WooCommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;
?>

<?php if ( get_theme_mod( 'woocommerce_shop_layout', 'wide' ) == 'wide' ) : ?>
	<div id="offcanvas_widget_shop" class="rt-slidepanel is-slidepanel-right rt-offcanvas-widget-shop">

		<div class="rt-slidepanel__overlay js-slidepanel-close"></div>

		<div class="rt-slidepanel__inner">

			<div class="rt-slidepanel__wrapper">
				<div class="rt-slidepanel__header px-30 py-30 md:px-60 md:py-40">
					<h4 class="rt-slidepanel__title"><?php echo esc_html__( 'Filters', 'kubelio' ); ?></h4>
					<a class="rt-slidepanel__close js-slidepanel-close" role="button"
						aria-label="<?php echo esc_attr__( 'Close menu', 'kubelio' ); ?>">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
							class="bi bi-x-lg" viewBox="0 0 16 16">
							<path fill-rule="evenodd"
								d="M13.854 2.146a.5.5 0 0 1 0 .708l-11 11a.5.5 0 0 1-.708-.708l11-11a.5.5 0 0 1 .708 0Z">
							</path>
							<path fill-rule="evenodd"
								d="M2.146 2.146a.5.5 0 0 0 0 .708l11 11a.5.5 0 0 0 .708-.708l-11-11a.5.5 0 0 0-.708 0Z">
							</path>
						</svg>
					</a>
				</div>
				<div class="rt-slidepanel__body has-x-small-font-size is-layout-flow px-30 py-30 md:px-60 md:py-40">
					<?php dynamic_sidebar( 'retheme_shop_filter' ); ?>
				</div>
			</div>

		</div>

	</div>
<?php endif; ?>