<?php

/**
 * Order Item Details
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
	return;
}
?>
<tr
	class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">

	<td class="woocommerce-table__product-name product-name" colspan="2">

		<div class="rt-product-items flex gap-30">
			<div class="rt-product-item flex flex-1 nowrap gap-30">

				<?php if ( rt_fs()->can_use_premium_code() ) : ?>
					<div class="rt-product-item__thumbnail rounded-sm overflow-hidden rt-img is-fixed-width" style="flex-basis: 70px">
						<?php echo $product->get_image( 'thumbnail' ); ?>
					</div>
				<?php endif ?>
				
				<div class="rt-product-item__body">
					<?php
					$is_visible        = $product && $product->is_visible();
					$product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );

					echo "<div class='rt-product-item__name has-x-small-font-size leading-lg'>";
					echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', $product_permalink ? sprintf( '<a href="%s">%s</a>', $product_permalink, $item->get_name() ) : $item->get_name(), $item, $is_visible ) );

					$qty          = $item->get_quantity();
					$refunded_qty = $order->get_qty_refunded_for_item( $item_id );

					if ( $refunded_qty ) {
						$qty_display = '<del>' . esc_html( $qty ) . '</del> <ins>' . esc_html( $qty - ( $refunded_qty * -1 ) ) . '</ins>';
					} else {
						$qty_display = esc_html( $qty );
					}

					echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', $qty_display ) . '</strong>', $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

					echo '</div>';

					do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );

					wc_display_item_meta( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

					do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
					?>

					<div class="woocommerce-table__product-total product-total-mobile has-x-small-font-size">
						<?php
						echo $order->get_formatted_line_subtotal( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
						?>
					</div>
				</div>
			</div>

			<div class="woocommerce-table__product-total product-total has-x-small-font-size text-right">
				<?php
				echo $order->get_formatted_line_subtotal( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
				?>
			</div>
		</div>
	</td>

</tr>

<?php if ( $show_purchase_note && $purchase_note ) : ?>

	<tr class="woocommerce-table__product-purchase-note product-purchase-note">

		<td colspan="2">
		<?php
		echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
		?>
						</td>

	</tr>

<?php endif; ?>