<?php
/**
 * Product Loop Start
 *
 * Wrap the default ul with div tag HTML.
 * Added CSS classes for get layout from options.
 *
 * @see https://github.com/woocommerce/woocommerce/blob/trunk/plugins/woocommerce/templates/loop/loop-start.php
 * @package     WooCommerce\Templates
 * @version     3.3.0
 */

defined( 'ABSPATH' ) || exit;

$columns         = esc_attr( wc_get_loop_prop( 'columns' ) );
$stack_on_mobile = get_theme_mod( 'woocommerce_shop_catalog_stack_on_mobile', false );

$class_catalog = $stack_on_mobile === true
	? 'rt-products products grids grids-1 md:grids-' . $columns
	: 'rt-products products grids grids-2 gap-30 md:gap-40 md:grids-' . $columns;

?>
<div class="<?php echo esc_attr( $class_catalog ); ?>">