<?php

/**
 * Custom WooCommerce Checkout Review Order Item Template
 *
 * This template displays individual product items in the order review section during checkout.
 * It overrides the default WooCommerce template to provide enhanced display with product thumbnails
 * and improved HTML structure for better theming and styling.
 *
 * @package Retheme\WooCommerce
 * @version     1.0.0
 *
 * @see woocommerce/templates/checkout/review-order.php
 */
defined( 'ABSPATH' ) || exit;

$product_thumbnail = $_product->get_image( 'thumbnail' );
$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
$product_quantity  = apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key );
$product_price     = $_product->get_price_html();
$product_data      = wc_get_formatted_cart_item_data( $cart_item );
$product_subtotal  = apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
?>
<tr
	class="product-item-table-responsive <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
	<td class="product-item" colspan="2">
		<div class="rt-product-items flex gap-30">
			<div class="rt-product-item flex flex-1 nowrap gap-30">
				<?php if ( rt_fs()->can_use_premium_code() ) : ?>
					<div class="rt-product-item__thumbnail rounded-sm overflow-hidden rt-img is-fixed-width" style="flex-basis: 70px">
						<?php echo $product_thumbnail; ?>
					</div>
				<?php endif ?>
				<div class="rt-product-item__body">
					<div class="rt-product-item__name has-x-small-font-size leading-lg">
						<?php echo wp_kses_post( $product_name ); ?>
					</div>
					<div class="rt-product-item__price product-price has-xx-small-font-size">
						<?php
						echo $product_price . $product_quantity // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ; 
						?>
					</div>
					<?php if ( $product_data ) : ?>
						<div class="rt-product-item__price has-xx-small-font-size has-meta-color leading-sm">
							<?php
							echo $product_data // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ; 
							?>
						</div>
					<?php endif; ?>

				</div>
			</div>
			<span class="product-subtotal has-x-small-font-size text-right">
				<?php
				echo $product_subtotal; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
				?>
			</span>
		</div>
	</td>
</tr>