<?php
/**
 * @package Retheme
 * @since 1.0.0
 *
 * This template is designed specifically for checkout pages, removing unnecessary theme elements
 * such as the header, footer, and sidebar to provide a distraction-free checkout experience.
 * Added steps numbering for better user guidance during the checkout process.
 */
?>

<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Back link
if ( rt_is_woocommerce( array( 'cart', 'thank_page' ) ) ) {
	$url_target = get_permalink( wc_get_page_id( 'shop' ) );
	$url_label  = esc_html__( 'Back to Shop', 'kubelio' );
} else {
	$url_target = get_permalink( wc_get_page_id( 'cart' ) );
	$url_label  = esc_html__( 'Back to Cart', 'kubelio' );
}

/**
 * Logo
 *
 * Get the logo form costumizer settings.
 * If no logo for checkout is set, use the primary logo.
 */
$logo = get_theme_mod( 'brand_logo_checkout' );
if ( empty( $logo['url'] ) ) {
	$logo = get_theme_mod( 'brand_logo_primary' );
}
$logo_img = wp_sprintf( '<img src="%1$s" class="%2$s" alt="%3$s" />', esc_url( $logo['url'] ), 'site-logo-img', esc_attr( get_bloginfo( 'name' ) ) );

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>

</head>

<body <?php body_class( 'retheme-root retheme-default-scheme no-js' ); ?>>
	<?php wp_body_open(); ?>

	<main class="site-main wp-site-blocks">

		<header class="site-checkout-header has-background-background-color  border-bottom py-30 has-global-padding">
			<div class="site-container is-layout-flex justify-between align-items-center">

				<a class="rt-logo" href='<?php echo site_url(); ?>' rel='home'>
					<span class="rt-logo__primary"><?php echo $logo_img; ?></span>
				</a>

				<div class="is-layout-flex gap-20">
					<span class="rt-back-to-button has-x-small-font-size has-link-meta-alt-color">
						<a href="<?php echo esc_url( $url_target ); ?>">
							<i class="rt-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8" />
								</svg>
							</i>
							<?php echo $url_label; ?>
						</a>
					</span>
					<span class="rt-header-checkout-separtor hidden md:block" style="opacity: .2;">|</span>
					<h1 class="has-small-font-size hidden md:block"><?php echo get_the_title(); ?></h1>
				</div>
			</div>
		</header>

		<section class="site-wrapper md:mt-60">
			<?php if ( have_posts() ) : ?>
				<?php
				while ( have_posts() ) :
					the_post();
					?>

					<div class="entry-content entry-content wp-block-post-content has-global-padding is-layout-constrained">
						<div class="alignwide">
							<?php the_content(); ?>
							<?php wp_link_pages(); ?>
						</div>
					</div>

				<?php endwhile; ?>
			<?php endif ?>
		</section>

		<footer class="site-checkout-footer has-global-padding has-foreground-background-color has-x-small-font-size has-body-color text-center py-30 has-global-padding">
			<div class="site-container is-layout-flex justify-between align-items-center">
				<?php echo rt_get_site_copyright(); ?>
			</div>
		</footer>

	</main>

	<?php rt_get_template_part( 'global/gotop' ); ?>
	<?php wp_footer(); ?>
</body>

</html>