<?php
/**
 * Template Name: Without Title
 *
 * @package Retheme
 * @since 1.0.0
 *
 * This template displays page content without the title.
 * It's useful for pages where you want to use a custom header or hero section
 * without the default page title appearing above the content.
 *
 * @link https://developer.wordpress.org/themes/template-files-section/page-template-files/
 */
?>

<?php get_header(); ?>

<section class="site-wrapper">
	<?php if ( have_posts() ) : ?>
		<?php
		while ( have_posts() ) :
			the_post();
			?>

			<div class="entry-content entry-content wp-block-post-content has-global-padding is-layout-constrained">
				<?php the_content(); ?>
				<?php wp_link_pages(); ?>
			</div>

		<?php endwhile; ?>
	<?php endif ?>
</section>

<?php get_footer(); ?>