<?php
/**
 * Template Name: Blank Canvas
 *
 * @package Retheme
 * @since 1.0.0
 *
 * This is a minimal template that displays content without any theme elements.
 * It's ideal for page builders or when you need a clean slate without header, footer, or sidebar.
 *
 * @link https://developer.wordpress.org/themes/template-files-section/page-template-files/
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>

</head>

<body <?php body_class( 'retheme-root retheme-default-scheme no-js' ); ?>>
	<?php wp_body_open(); ?>
	<div class="entry-content entry-content wp-block-post-content is-layout-constrained">
		<?php if ( have_posts() ) : ?>
			<?php
			while ( have_posts() ) :
				the_post();
				?>
				<?php the_content(); ?>
			<?php endwhile; ?>
		<?php endif ?>
	</div>
	<?php wp_footer(); ?>
</body>

</html>