<?php if ( ( is_single() && get_theme_mod( 'single_element_sharebox', true ) ) || ( rt_is_woocommerce( 'product' ) && get_theme_mod( 'woocommerce_element_sharebox', true ) ) ) : ?>
	<div class="rt-post-share is-layout-flex gap-20">

		<ul class="wp-block-social-links is-style-box-gray has-small-icon-size is-layout-flex gap-30">

			<?php if ( get_theme_mod( 'connect_share_facebook', true ) ) : ?>
				<li class="wp-social-link wp-social-link-facebook wp-block-social-link">
					<a class="wp-block-social-link-anchor" target="_blank" rel="noopener noreferrer nofollow" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php echo esc_attr__( 'share on facebook', 'kubelio' ); ?>">

						<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
							<path d="M12 2C6.5 2 2 6.5 2 12c0 5 3.7 9.1 8.4 9.9v-7H7.9V12h2.5V9.8c0-2.5 1.5-3.9 3.8-3.9 1.1 0 2.2.2 2.2.2v2.5h-1.3c-1.2 0-1.6.8-1.6 1.6V12h2.8l-.4 2.9h-2.3v7C18.3 21.1 22 17 22 12c0-5.5-4.5-10-10-10z"></path>
						</svg>
						<span class="wp-block-social-link-label screen-reader-text"><?php echo esc_html__( 'Facebook', 'kubelio' ); ?></span>
					</a>
				</li>
			<?php endif; ?>

			<?php if ( get_theme_mod( 'connect_share_twitter', true ) ) : ?>
				<li class="wp-social-link wp-social-link-x wp-block-social-link">
					<a class="wp-block-social-link-anchor" target="_blank" rel="noopener noreferrer nofollow" href="https://twitter.com/intent/tweet?url=<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php echo esc_attr__( 'share on x', 'kubelio' ); ?>">

						<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
							<path d="M13.982 10.622 20.54 3h-1.554l-5.693 6.618L8.745 3H3.5l6.876 10.007L3.5 21h1.554l6.012-6.989L15.868 21h5.245l-7.131-10.378Zm-2.128 2.474-.697-.997-5.543-7.93H8l4.474 6.4.697.996 5.815 8.318h-2.387l-4.745-6.787Z"></path>
						</svg>
						<span class="wp-block-social-link-label screen-reader-text"><?php echo esc_html__( 'Twitter', 'kubelio' ); ?></span>

					</a>
				</li>
			<?php endif; ?>

			<?php if ( get_theme_mod( 'connect_share_pinterest', true ) ) : ?>
				<li class="wp-social-link wp-social-link-pinterest wp-block-social-link">
					<a class="wp-block-social-link-anchor" target="_blank" rel="noopener noreferrer nofollow" href="https://pinterest.com/pin/create/bookmarklet/?media=<?php the_post_thumbnail_url(); ?> url=<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php echo esc_attr__( 'share on pinterest', 'kubelio' ); ?>">

						<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
							<path d="M12.289,2C6.617,2,3.606,5.648,3.606,9.622c0,1.846,1.025,4.146,2.666,4.878c0.25,0.111,0.381,0.063,0.439-0.169 c0.044-0.175,0.267-1.029,0.365-1.428c0.032-0.128,0.017-0.237-0.091-0.362C6.445,11.911,6.01,10.75,6.01,9.668 c0-2.777,2.194-5.464,5.933-5.464c3.23,0,5.49,2.108,5.49,5.122c0,3.407-1.794,5.768-4.13,5.768c-1.291,0-2.257-1.021-1.948-2.277 c0.372-1.495,1.089-3.112,1.089-4.191c0-0.967-0.542-1.775-1.663-1.775c-1.319,0-2.379,1.309-2.379,3.059 c0,1.115,0.394,1.869,0.394,1.869s-1.302,5.279-1.54,6.261c-0.405,1.666,0.053,4.368,0.094,4.604 c0.021,0.126,0.167,0.169,0.25,0.063c0.129-0.165,1.699-2.419,2.142-4.051c0.158-0.59,0.817-2.995,0.817-2.995 c0.43,0.784,1.681,1.446,3.013,1.446c3.963,0,6.822-3.494,6.822-7.833C20.394,5.112,16.849,2,12.289,2"></path>
						</svg>

						<span class="wp-block-social-link-label screen-reader-text"><?php echo esc_html__( 'Pinterest', 'kubelio' ); ?></span>
					</a>
				</li>
			<?php endif; ?>

			<?php if ( get_theme_mod( 'connect_share_email', true ) ) : ?>
				<li class="wp-social-link wp-social-link-mail wp-block-social-link">
					<a class="wp-block-social-link-anchor" href="mailto:?subject=<?php echo wp_strip_all_tags( get_the_title() ); ?>" body="<?php echo get_permalink(); ?>" title="<?php echo wp_strip_all_tags( get_the_title() ); ?>" aria-label="<?php echo esc_attr__( 'share on mail', 'kubelio' ); ?>">

						<svg width="24" height="24" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
							<path d="M20,4H4C2.895,4,2,4.895,2,6v12c0,1.105,0.895,2,2,2h16c1.105,0,2-0.895,2-2V6C22,4.895,21.105,4,20,4z M20,8.236l-8,4.882 L4,8.236V6h16V8.236z"></path>
						</svg>
						<span class="wp-block-social-link-label screen-reader-text"><?php echo esc_html__( 'Mail', 'kubelio' ); ?></span>

					</a>
				</li>
			<?php endif; ?>

			<?php if ( get_theme_mod( 'connect_share_whatsapp', true ) ) : ?>
				<li class="wp-social-link wp-social-link-whatsapp wp-block-social-link">
					<a class="wp-block-social-link-anchor" target="_blank" rel="noopener noreferrer nofollow" href="https://api.whatsapp.com/send?text=<?php echo rawurlencode( wp_strip_all_tags( get_the_title() . ' - ' . get_permalink() ) ); ?>"
						aria-label="<?php echo esc_attr__( 'share on whatsapp', 'kubelio' ); ?>">

						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16">
							<path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232" />
						</svg>
						<span class="wp-block-social-link-label screen-reader-text"><?php echo esc_html__( 'WhatsApp', 'kubelio' ); ?></span>

					</a>
				</li>
			<?php endif; ?>

		</ul>
	</div>

<?php endif ?>