<?php
$terms    = get_the_terms( get_the_ID(), 'category' );
$term_ids = array();

if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
	foreach ( $terms as $key => $term ) {
		$term_ids[] = $term->term_id;
	}
}

$the_query = new \WP_Query(
	array(
		'post__not_in'        => array( get_the_ID() ),
		'post_type'           => 'post',
		'posts_per_page'      => get_theme_mod( 'single_related_count', 6 ),
		'ignore_sticky_posts' => true,
		'tax_query'           => array(
			array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $term_ids,
				'operator' => 'IN',
			),
		),
	)
);

// Swiper options
$slider_options = htmlspecialchars(
	json_encode(
		array(
			'slidesPerView' => 1,
			'spaceBetween'  => 15,
			'itemWrapper'   => '.rt-post__thumbnail',
			'breakpoints'   => array(
				728 => array(
					'slidesPerView' => 3,
				),
			),
		)
	)
);
?>


<?php if ( $the_query->have_posts() && get_theme_mod( 'single_related', true ) ) : ?>
	<div class="wp-block-group">
		<div id="posts-related-carousel" class="rt-post-relateds">
			<div class="rt-block-heading">
				<h2 class="rt-block-heading__title"><?php echo esc_html__( 'Related Posts', 'kubelio' ); ?></h2>
			</div>
			<div class="wp-block-group">
				<div class="rt-swiper is-swiper-pagination-outside" style="--slides: 1; --gap: 30px; --slides-md: 3; --gap-md: 30px;">					
					<div class="swiper js-swiper" data-options="<?php echo esc_attr( $slider_options ); ?>">
						<div class="swiper-wrapper">
							<?php
							while ( $the_query->have_posts() ) :
								$the_query->the_post();
								?>
								<div class="swiper-slide">
									<div class="rt-swiper-item"><?php rt_get_template_part( 'post/post-grid' ); ?></div>
								</div>
							<?php endwhile ?>
							<?php wp_reset_postdata(); ?>
						</div>
						<div class="swiper-pagination mt-20">
							<span class="swiper-pagination-bullet"></span>
							<span class="swiper-pagination-bullet"></span>
							<span class="swiper-pagination-bullet"></span>
						</div>
					</div>
					<div class="rt-swiper-navigation">
						<div class="swiper-button-prev"></div>
						<div class="swiper-button-next"></div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php endif ?>

<?php wp_reset_postdata(); ?>