<?php
$date_url    = esc_url( get_day_link( get_the_time( 'Y' ), get_the_time( 'm' ), get_the_time( 'd' ) ) );
$author_id   = get_post_field( 'post_author', get_the_ID() );
$author_url  = get_author_posts_url( $author_id );
$avatar      = get_avatar( $author_id, 30 );
$avatar_url  = get_the_author_meta( 'profile_avatar', $author_id );
$author_name = get_the_author_meta( 'display_name', $author_id );
$terms       = get_the_category();
$count_terms = count( $terms );

$meta = get_theme_mod( 'single_meta', array( 'meta-date', 'meta-view', 'meta-reading', 'meta-comment' ) );
?>

<?php if ( $meta ) : ?>
	<div class="rt-post-meta is-layout-flex has-x-small-font-size has-meta-color has-link-meta-color gap-20">

		<?php if ( in_array( 'meta-author', $meta ) ) : ?>
			<a class="rt-post-meta__item rt-post-meta-author" href="<?php echo esc_url( $author_url ); ?>">
				<?php echo esc_html( wp_sprintf( esc_html__( 'By %s', 'kubelio' ), get_the_author() ) ); ?>
			</a>
			<span class="rt-post-meta__separator">•</span>
		<?php endif ?>

		<?php if ( in_array( 'meta-date', $meta ) ) : ?>

			<a class="rt-post-meta__item rt-post-meta-date" href="<?php echo esc_url( $date_url ); ?>">
				<span class="rt-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">
						<path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71z"></path>
						<path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0"></path>
					</svg>
				</span>
				<?php echo get_the_date(); ?>
			</a>
			<span class="rt-post-meta__separator">•</span>
		<?php endif ?>

		<?php if ( get_comments_number() >= 1 && in_array( 'meta-comment', $meta ) ) : ?>

			<?php
			$comment_count = get_comments_number();
			$comment_text  = _n( 'Comment', 'Comments', $comment_count, 'kubelio' );
			?>
			<a href="#comments" class="js-smooth-scroll rt-post-meta__item rt-post-meta-comment" role="button" aria-label="<?php echo esc_html__( 'scroll to comments', 'kubelio' ); ?>">
				<?php echo wp_sprintf( esc_html( '%s %s', 'kubelio' ), $comment_count, $comment_text ); ?>
			</a>
			<span class="rt-post-meta__separator">•</span>
		<?php endif ?>

	</div>
<?php endif ?>