<?php
if ( get_theme_mod( 'single_element_authorbox', true ) ) :
	$author_id         = get_the_author_meta( 'ID' );
	$author_avatar     = get_avatar( $author_id, 70, '', '', array( 'class' => 'rounded-full' ) );
	$author_avatar_url = get_user_meta( $author_id, 'avatar', true );
	$author_url        = get_author_posts_url( $author_id );
	$author_name       = get_the_author_meta( 'display_name' );
	$author_desc       = get_the_author_meta( 'description' );
	?>

	<div class="wp-block-post-author has-foreground-background-color rounded-md px-40 py-40 mt-60">
		<div class="wp-block-columns is-layout-flex">
			<div class="wp-block-column" style="flex-basis:70px">
				<div class="wp-block-post-author__avatar mr-0">
					<?php
					if ( $author_avatar_url ) {
						echo wp_kses_post( wp_get_attachment_image( $author_avatar_url, 'thumbnail', '', array( 'class' => 'rounded-full' ) ) );
					} else {
						echo wp_kses_post( $author_avatar );
					}
					?>
				</div>
			</div>
			<div class="wp-block-column">
				<div class="wp-block-post-author__content">
					<h4 class="wp-block-post-author__name has-link-heading-color">
						<a href="<?php echo esc_url( $author_url ); ?>">
							<?php echo esc_html( $author_name ); ?>
						</a>
					</h4>

					<div class="wp-block-post-author__bio has-small-font-size mt-20 mb-0">
						<?php echo esc_html( $author_desc ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>