<?php $terms = get_the_terms( get_the_ID(), 'category' ); ?>

<article <?php post_class( 'rt-post is-style-grid is-layout-flow' ); ?>>

	<?php if ( has_post_thumbnail() ) : ?>
		<figure class="rt-post__thumbnail rt-img has-aspect-ratio rounded-md relative" style="aspect-ratio: 16/9;">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php the_post_thumbnail( 'featured_medium' ); ?>
			</a>

			<?php if ( $terms && ! is_wp_error( $terms ) && get_theme_mod( 'post_element_category', true ) ) : ?>
				<div class="wp-group absolute top-0 left-0 py-20 px-20">
					<div class="wp-block-post-terms is-style-colored has-xx-small-font-size">
						<?php foreach ( $terms as $term ) : ?>
							<a class="<?php echo 'category-' . esc_attr( $term->slug ); ?>" href="<?php echo esc_url( get_tag_link( $term->term_id ) ); ?>">
								<?php echo esc_html( $term->name ); ?>	 
							</a>
						<?php endforeach; ?>
					</div>
				</div>
			<?php endif ?>

		</figure>
	<?php endif ?>

	<div class="rt-post__body is-layout-flow mt-30">

		<h3 class="rt-post__title has-small-font-size md:has-medium-font-size has-link-overlay line-clamp-3">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		</h3>

		<?php rt_get_template_part( 'post/post-meta' ); ?>

		<?php if ( get_theme_mod( 'post_element_content', true ) ) : ?>
			<div class="rt-post__excerpt has-x-small-font-size is-hidden md:block mt-20">
				<?php echo wp_trim_words( get_the_excerpt(), get_theme_mod( 'post_excerpt_length', 20 ) ); ?>
			</div>
		<?php endif ?>

	</div>
</article>