<?php
$meta  = get_theme_mod( 'post_meta', array( 'meta-comment', 'meta-date' ) );
$terms = get_the_terms( get_the_ID(), 'category' );
?>

<?php if ( $meta ) : ?>
	<div class="rt-post-meta is-layout-flex has-xx-small-font-size has-meta-color mt-10 md:mt-20 gap-10">

		<?php if ( in_array( 'meta-author', $meta ) ) : ?>
			<span class="rt-post-meta__item rt-post-meta-author">
				<?php echo wp_sprintf( esc_html__( 'By %s', 'kubelio' ), get_the_author() ); ?>
			</span>
			<span class="rt-post-meta__separator">•</span>
		<?php endif ?>

		<?php if ( in_array( 'meta-date', $meta ) ) : ?>
			<span class="rt-post-meta__item rt-post-meta-date">
				<span class="rt-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">
						<path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71z"></path>
						<path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0"></path>
					</svg>
				</span>
				<?php echo get_the_date(); ?>
			</span>
			<span class="rt-post-meta__separator">•</span>
		<?php endif ?>

		<?php
		if ( get_comments_number() >= 1 && in_array( 'meta-comment', $meta ) ) :
			$comment_count = get_comments_number();
			$comment_text  = _n( 'Comment', 'Comments', $comment_count, 'kubelio' );
			?>
			<span class="rt-post-meta__item rt-post-meta-comment">
				<?php echo wp_sprintf( esc_html( '%s %s', 'kubelio' ), $comment_count, $comment_text ); ?>
			</span>
			<span class="rt-post-meta__separator">•</span>
		<?php endif; ?>

	</div>
<?php endif ?>