<?php

/**
 * Header Mobile Template
 *
 * @package Kubelio
 */

$wishlist_enable           = rt_is_wishlist_enabled();
$wishlist_count            = rt_get_wishlist_count();
$wishlist_count_visibility = ($wishlist_count >= 1) ? 'flex' : 'none';
?>

<header class="site-header-mobile mt-0 js-header border-bottom" data-sticky="<?php echo esc_attr(get_theme_mod('header_sticky', 'up')); ?>">
	<div class="site-header-mobile__main has-global-padding has-background-background-color has-body-color has-link-body-color py-30">
		<div class="site-container">
			<div class="wp-block-columns is-not-stacked-on-mobile is-layout-flex flex-nowrap">

				<div class="wp-block-column is-layout-flex flex-initial justify-center">
					<?php echo wp_kses_post(rt_get_logo('mobile')); ?>
				</div>

				<div class="wp-block-column is-layout-flex flex-1 justify-right" style="gap: 20px">
					<?php if (get_theme_mod('woocommerce_shop_mobile_navbar', false) === false) : ?>

						<?php if (get_theme_mod('header_account_icon', true)) : ?>
							<a class="rt-popover" href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>" role="button" aria-label="<?php esc_attr_e('open my account', 'kubelio'); ?>" data-popover="<?php esc_attr_e('Account', 'kubelio'); ?>">
								<i class="rt-icon">
									<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2" viewBox="0 0 84 84">
										<path d="M0 0h83.333v83.333H0z" style="fill:none" />
										<path d="M22.917 54.912h37.5c5.753 0 10.416 4.664 10.416 10.417v16.615h8.334V65.329c0-10.356-8.395-18.75-18.75-18.75h-37.5c-10.356 0-18.75 8.394-18.75 18.75v16.615H12.5V65.329c0-5.753 4.664-10.417 10.417-10.417m18.75-52.083c-10.349 0-18.75 8.401-18.75 18.75s8.401 18.75 18.75 18.75 18.75-8.402 18.75-18.75-8.402-18.75-18.75-18.75m0 8.333c5.749 0 10.416 4.668 10.416 10.417s-4.667 10.417-10.416 10.417S31.25 27.328 31.25 21.579s4.668-10.417 10.417-10.417" />
									</svg>
								</i>
							</a>
						<?php endif ?>

						<?php if ($wishlist_enable) : ?>
							<a href="<?php echo esc_url(get_permalink(get_option('woocommerce_shop_page_id')) . '?queryby=wishlist'); ?>" class="rt-popover rt-wishlist-info" role="button" aria-label="<?php echo esc_attr__('open wishlist', 'kubelio'); ?>" data-popover="<?php echo esc_attr__('Wishlist', 'kubelio'); ?>">
								<i class="rt-icon">
									<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2" viewBox="0 0 84 84">
										<path d="M0 0h83.333v83.333H0z" style="fill:none" />
										<path d="M41.659 7.928c7.375-5.426 16.915-5.983 24.994-2.658 18.88 7.769 31.938 39.26-22.642 75.33l-2.354 1.436-2.355-1.436C-15.278 44.534-2.223 13.046 16.657 5.273c8.082-3.326 17.624-2.77 25.002 2.655m-.003 63.963C19.962 57.071 10.683 43.677 9.073 32.827c-1.437-9.685 3.862-16.784 10.836-19.655 5.896-2.427 12.986-1.902 18.038 2.747.223.206 3.746 3.799 3.746 3.799l3.646-3.77c5.078-4.678 12.168-5.206 18.064-2.779 6.973 2.869 12.273 9.968 10.836 19.654-1.609 10.851-10.888 24.246-32.583 39.068" />
									</svg>
								</i>
								<span class="rt-wishlist-info__badge rt_wishlist_count" style="display: <?php echo esc_attr($wishlist_count_visibility); ?>"><?php echo esc_html($wishlist_count); ?></span>
							</a>
						<?php endif ?>

						<?php if (get_theme_mod('header_cart_icon', true)) : ?>
							<?php if (rt_is_woocommerce(array('cart', 'checkout'))) : ?>
								<a class="rt-cart-info rt-popover" role="button" href="<?php echo esc_url(get_permalink(get_option('woocommerce_cart_page_id'))); ?>" aria-label="<?php esc_attr_e('open mini cart', 'kubelio'); ?>" data-popover="<?php echo esc_attr__('Cart', 'kubelio'); ?>">
									<i class="rt-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2" viewBox="0 0 84 84">
											<path d="M0 0h83.333v83.333H0z" style="fill:none" />
											<path d="M28.784 66.013c4.266 0 7.73 3.356 7.73 7.491s-3.464 7.491-7.73 7.491-7.729-3.357-7.729-7.491c0-4.135 3.463-7.491 7.729-7.491m41.224 0c4.265 0 7.729 3.356 7.729 7.491s-3.464 7.491-7.729 7.491-7.73-3.357-7.73-7.491c0-4.135 3.464-7.491 7.73-7.491M14.93 21.834l-.02-.098-2.233-11.907H5.596c-2.134 0-3.864-1.677-3.864-3.745s1.73-3.746 3.864-3.746h10.306c1.868 0 3.468 1.295 3.802 3.076l2.234 11.907h55.799a3.92 3.92 0 0 1 2.92 1.291 3.67 3.67 0 0 1 .906 2.984L76.41 56.554c-.272 1.846-1.902 3.216-3.826 3.216H26.208c-1.832 0-3.412-1.246-3.784-2.984zm8.533 2.978 5.889 27.467h39.88l4.049-27.467z" />
										</svg>
									</i>
									<span class="rt-cart-info__badge"><?php echo esc_html(rt_woocommerce_get_cart_count()); ?></span>
								</a>
							<?php else : ?>
								<span class="rt-popover flex items-center" data-popover="<?php esc_attr_e('Cart', 'kubelio'); ?>">
									<?php echo do_blocks('<!-- wp:woocommerce/mini-cart /-->'); ?>
								</span>
							<?php endif; ?>
						<?php endif; ?>

					<?php endif ?>
					<a href="#offcanvas_mobile_menu" class="rt-menu-toggle rt-menu-toggle--point js-animate" role="button" aria-label="<?php echo esc_attr__('open menu', 'retheme-text'); ?>"><span></span></a>
				</div>

			</div>
		</div>
	</div>
	<div id="offcanvas_mobile_menu" class="rt-offcanvas-mobile-menu has-background-background-color has-body-color absolute left-0 right-0" data-animatein="slideDown" data-animateout="slideUp" style="display: none;">
		<div class="py-30">

			<?php if (get_theme_mod('header_search_icon', true)) : ?>
				<div class="rt-search-form px-30">
					<form class="rt-search-form__inner" action="<?php echo esc_url(home_url('/')); ?>" method="get">
						<input class="rt-search-form__input" type="search" placeholder="<?php echo esc_attr(get_option('global_search_label', __('Search products', 'retheme-text'))); ?>" name="s" id="s">
						<input type="hidden" name="post_type" value="<?php echo esc_attr(get_option('global_search_post_type', 'product')); ?>" />
						<button type="submit" class="rt-search-form__icon" aria-label="<?php echo esc_attr__('Search products', 'kubelio'); ?>">
							<i class="rt-icon" style="color: #333">
								<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2" viewBox="0 0 84 84">
									<path d="M0 0h83.333v83.333H0z" style="fill:none" />
									<path d="M35.183 3.102c17.831 0 32.419 14.589 32.419 32.42 0 7.565-2.701 14.589-7.024 19.992l20.533 20.532-5.944 5.944-20.532-20.532c-5.404 4.322-12.428 7.024-19.993 7.024-17.83 0-32.419-14.589-32.419-32.42s15.129-32.96 32.96-32.96m0 56.735a24.213 24.213 0 0 0 24.314-24.315 24.213 24.213 0 0 0-24.314-24.315 24.214 24.214 0 0 0-24.315 24.315 24.214 24.214 0 0 0 24.315 24.315" style="fill-rule:nonzero" />
								</svg>
							</i>
						</button>
					</form>
				</div>
			<?php endif ?>

			<nav id="menu-primary" class="rt-menu is-menu-vertical has-x-small-font-size js-menu mt-20">
				<?php
				wp_nav_menu(
					array(
						'container'      => '',
						'theme_location' => 'primary',
						'fallback_cb'    => 'rt_menu_default',
					)
				);
				?>
			</nav>

			<?php if (get_theme_mod('header_button', false)) : ?>
				<div class="rt-offcanvas-mobile-menu__button px-30 mt-20">
					<a class="rt-btn is-style-primary is-size-sm" href="<?php echo esc_url(get_theme_mod('header_button_url', '#')); ?>" target="<?php echo esc_attr(get_theme_mod('header_button_target', false) ? '_blank' : '_self'); ?>">
						<?php echo esc_html(get_theme_mod('header_button_text', esc_html__('Get Started', 'kubelio'))); ?>
					</a>
				</div>
			<?php endif ?>
		</div>
	</div>
</header>