<?php get_header(); ?>

<section class="site-wrapper is-layout-flow">


	<?php if ( have_posts() ) : ?>
		<?php
		while ( have_posts() ) :
			the_post();
			?>

			<div class="wp-block-group has-global-padding is-layout-constrained md:mt-60">
				<div class="alignwide">

					<div class="wp-block-columns is-layout-flex is-stacked-on-tablet md:gap-60">
						<div class="site-content wp-block-column is-layout-flow">

							<?php rt_get_template_part( 'single/category' ); ?>

							<?php echo rt_get_breadrumbs(); ?>

							<h1 class="wp-block-post-title mt-20"><?php the_title(); ?></h1>

							<div class="wp-block-columns is-layout-flex items-start gap-30 has-x-small-font-size has-meta-color has-link-meta-color">
								<div class="wp-block-column is-layout-flex flex-1"><?php rt_get_template_part( 'single/meta' ); ?></div>
								<div class="wp-block-column is-layout-flex flex-initial md:justify-right"><?php rt_get_template_part( 'single/share' ); ?></div>
							</div>

							<?php rt_get_template_part( 'single/thumbnail' ); ?>

							<div class="entry-content wp-block-post-content is-layout-flow">
								<?php the_content(); ?>
								<?php wp_link_pages(); ?>
							</div>

							<div class="wp-block-columns is-layout-flex items-start md:mt-60">
								<div class="wp-block-column is-layout-flex flex-1"><?php rt_get_template_part( 'single/tag' ); ?></div>
								<div class="wp-block-column is-layout-flex flex-initial md:justify-right"><?php rt_get_template_part( 'single/share' ); ?></div>
							</div>

							<?php rt_get_template_part( 'single/author' ); ?>
							
							<?php
							if ( rt_fs()->can_use_premium_code() ) {
								rt_get_template_part( 'single/related' );
							}
							?>

							<?php if ( ( comments_open() || get_comments_number() ) && get_theme_mod( 'single_element_comment', true ) ) : ?>
								<div class="wp-block-group md:mt-60 md:mb-60">
									<div class="wp-block-post-comments has-small-font-size is-layout-flow has-foreground-background-color rounded-md py-30 px-30 md:py-40 md:px-40">
										<?php comments_template(); ?>
									</div>
								</div>
							<?php endif ?>

						</div>
						<div class="site-sidebar wp-block-column is-layout-flow">
							<?php get_sidebar(); ?>
						</div>
					</div>

				</div>
			</div>


		<?php endwhile; ?>
	<?php endif ?>


</section>

<?php get_footer(); ?>