<?php

/**
 * Kubelio functions file
 *
 * @author Kubelio
 * @package kubelio
 * @since 1.0.0
 */

if (! defined('ABSPATH')) {
	exit;
}
define('RT_THEME_NAME', wp_get_theme()->get('Name'));
define('RT_THEME_SLUG', str_replace(' ', '-', strtolower(wp_get_theme()->get('Name'))));
define('RT_THEME_VERSION', wp_get_theme()->get('Version'));
define('RT_THEME_URL', wp_get_theme()->get('ThemeURI'));
define('RT_THEME_DOC', 'https://docs.kubelio.com');
define('RT_THEME_DEMO_URL', 'https://demo.kubelio.com/main');
define('RT_THEME_DEMO_ID', 2);

// Init freemius.
if (! function_exists('rt_fs')) {
	/**
	 * Create a helper function for easy SDK access.
	 *
	 * @return object Freemius instance.
	 */
	function rt_fs() {
		global $rt_fs;
		if (! isset($rt_fs)) {
			// Include Freemius SDK.
			require_once __DIR__ . '/vendor/freemius/start.php';

			$rt_fs = fs_dynamic_init(
				array(
					'id'               => '22529',
					'slug'             => 'kubelio',
					'type'             => 'theme',
					'public_key'       => 'pk_64a47fa4df369bda055a4c7155845',
					'is_premium'       => false,
					'has_addons'       => false,
					'has_paid_plans'   => false,
					'is_org_compliant' => false,
					'menu'             => array(
						'slug'       => 'theme-panel',
						'first-path' => (get_theme_mod('demo_imported') === true ? 'admin.php?page=theme-panel' : 'themes.php?page=merlin'),
						'support'    => false,
					),
					'is_live'          => true,
				)
			);
		}
		return $rt_fs;
	}

	// Init Freemius.
	rt_fs();
	// Signal that SDK was initiated.
	do_action('retheme_fs_loaded');
}

// Include all core file.
require get_template_directory() . '/vendor/vendor.php';
require get_template_directory() . '/core/core.php';
