<?php

/**
 * WooCommerce Compatibility Theme and Global Functions.
 *
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Include WooCommerce files
 */
require_once __DIR__ . '/shop.php';
require_once __DIR__ . '/product.php';
require_once __DIR__ . '/checkout.php';

/**
 * WooCommerce support
 */
function rt_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'rt_woocommerce_support' );

/**
 * Added Custom Class CSS to Body HTML
 */
function rt_woocommerce_body_class( $classes ) {

	// Layout sidebar on product archive
	if ( rt_is_woocommerce( 'shop' ) ) {
		$layout    = get_theme_mod( 'woocommerce_shop_layout', 'wide' );
		$classes[] = 'has-shop-layout-' . $layout;
	}
	// Update cart quantity
	if ( rt_is_woocommerce( 'cart' ) && get_theme_mod( 'woocommerce_cart_quantity_auto_update', true ) ) {
		$classes[] = 'has-cart-quantity-auto-update';
	}

	// Distraction-Free Checkout
	if ( rt_is_woocommerce( array( 'cart', 'checkout', 'thank_page' ) ) && get_theme_mod( 'woocommerce_checkout_template_focus', true ) ) {
		$classes[] = 'has-checkout-template-focus';
	}

	return $classes;
}
add_filter( 'body_class', 'rt_woocommerce_body_class' );

/**
 * Register enqueue scripts
 */
function rt_woocommerce_scripts() {
	$theme_slug    = RT_THEME_SLUG;
	$theme_version = RT_THEME_VERSION;

	// Global scripts
	wp_enqueue_style( "{$theme_slug}-woocommerce", get_template_directory_uri() . '/assets/css/plugins/woocommerce.min.css', array( 'woocommerce-general' ), $theme_version );
	wp_enqueue_style( "{$theme_slug}-woocommerce-block", get_template_directory_uri() . '/assets/css/plugins/woocommerce-block.min.css', array( 'woocommerce-general' ), $theme_version );
	wp_enqueue_style( "{$theme_slug}-woocommerce-block-mini-cart", get_template_directory_uri() . '/assets/css/plugins/woocommerce-block-mini-cart.min.css', array( 'wc-blocks-style-mini-cart' ), $theme_version );

	// Quantiy increment field
	if ( get_theme_mod( 'woocommerce_product_quantity_field', true ) ) {
		wp_enqueue_script( "{$theme_slug}-quantity-field", get_template_directory_uri() . '/assets/js/quantity-field.min.js', '', $theme_version, true );
	}

	if ( rt_is_woocommerce( 'shop' ) ) {
		wp_enqueue_script( "{$theme_slug}-shop", get_template_directory_uri() . '/assets/js/shop.min.js', '', $theme_version, true );
	}

	if ( rt_is_woocommerce( 'cart' ) ) {
		wp_enqueue_script( "{$theme_slug}-cart", get_template_directory_uri() . '/assets/js/cart.min.js', array( 'jquery', "{$theme_slug}-swiper" ), $theme_version, true );
	}

	if ( rt_is_woocommerce( 'checkout' ) && get_theme_mod( 'woocommerce_checkout_move_coupon', true ) ) {
		wp_enqueue_script( "{$theme_slug}-checkout-move-coupon", get_template_directory_uri() . '/assets/js/checkout-move-coupon.min.js', '', $theme_version, true );
	}

	if ( rt_is_woocommerce( 'product' ) && get_theme_mod( 'woocommerce_product_gallery_slider', true ) ) {
		// GLightbox
		wp_enqueue_style( 'glightbox', get_template_directory_uri() . '/assets/glightbox/glightbox.min.css', '', $theme_version );
		wp_enqueue_script( 'glightbox', get_template_directory_uri() . '/assets/glightbox/glightbox.min.js', '', $theme_version, true );

		// Product gallery
		wp_enqueue_script( "{$theme_slug}-product-gallery", get_template_directory_uri() . '/assets/js/product-gallery.min.js', array( 'jquery', 'swiper', 'glightbox' ), $theme_version, true );
	}
}
add_action( 'wp_enqueue_scripts', 'rt_woocommerce_scripts', 99 );

/**
 * WooCommerce block editor style
 */
function rt_woocommerce_block_editor_style() {
	add_editor_style( 'assets/css/plugins/woocommerce.min.css' );
	add_editor_style( 'assets/css/plugins/woocommerce-block.min.css' );
	add_editor_style( 'assets/css/plugins/woocommerce-block-mini-cart.min.css' );
}
add_action( 'after_setup_theme', 'rt_woocommerce_block_editor_style', 98 );

/**
 * Remove WooCommerce page title
 */
add_filter( 'woocommerce_show_page_title', '__return_null' );

/**
 * Add WooCommerce wrapper with theme wrapper
 *
 * Remove default wrapper anda default sidebar WooCommerce.
 * Then add custom wrapper and custom sidebar.
 * Add cunditional sidebar for shop, product category, and product tag.
 */
function rt_woocommerce_theme_wrapper_start() {
	echo ( ! rt_is_woocommerce( 'product' ) ) ? rt_get_page_title() : '';
	echo '<section class="site-wrapper has-global-padding">';
	echo '<div class="site-container is-layout-flow">';

	if ( rt_is_woocommerce( 'shop' ) && in_array( get_theme_mod( 'woocommerce_shop_layout', 'wide' ), array( 'sidebar', 'sidebar-stack' ) ) ) {
		echo '<div class="wp-block-columns is-layout-flex is-stacked-on-tablet md:gap-60">';
		echo '<div class="site-content wp-block-column is-layout-flow">';
	}
}

function rt_woocommerce_theme_wrapper_end() {
	if ( rt_is_woocommerce( 'shop' ) && in_array( get_theme_mod( 'woocommerce_shop_layout', 'wide' ), array( 'sidebar', 'sidebar-stack' ) ) ) {
		echo '</div>'; // end content
		echo '<div class="site-sidebar wp-block-column is-layout-flow">';
		get_sidebar( 'shop' );
		echo '</div>';
		echo '</div>'; // end columns
	}
	echo '</div>';
	echo '</section>';
}

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
add_action( 'woocommerce_before_main_content', 'rt_woocommerce_theme_wrapper_start', 10 );
add_action( 'woocommerce_after_main_content', 'rt_woocommerce_theme_wrapper_end', 10 );

/**
 * Added header top shop page
 *
 * Remove result count and shop ordering.
 * Then add custom header top shop page.
 */
function rt_woocommerce_before_shop_loop() {
	get_template_part( 'woocommerce/shop-header' );
}

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
add_action( 'woocommerce_before_shop_loop', 'rt_woocommerce_before_shop_loop', 30 );

/**
 * Add theme breadcrumbs
 *
 * Remove default breadcrumbs WooCommerce.
 * Then add custom breadcrumbs.
 */
function rt_woocommerce_add_theme_breadcrumbs() {
	if ( function_exists( 'rt_get_breadrumbs' ) ) {
		echo rt_get_breadrumbs( array( 'class' => array( 'mb-30' ) ) );
	}
}
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
add_action( 'woocommerce_before_single_product_summary', 'rt_woocommerce_add_theme_breadcrumbs', 1 );

/**
 * Add theme pagination
 *
 * Remove default pagination WooCommerce.
 * Then add custom pagination.
 */
function rt_woocommerce_add_theme_pagination() {
	if ( function_exists( 'rt_get_pagination' ) ) {
		echo rt_get_pagination();
	}
}
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
add_action( 'woocommerce_after_shop_loop', 'rt_woocommerce_add_theme_pagination', 10 );

/**
 * Register shop sidebar
 */
function rt_woocommerce_register_sidebar_widget() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Filters Shop', 'kubelio' ),
			'id'            => 'retheme_shop_filter',
			'before_widget' => '<div id="%1$s" class="rt-widget is-widget-aside is-widget-shop-filter %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="rt-block-heading"><h3 class="rt-block-heading__title has-medium-font-size">',
			'after_title'   => '</h3></div>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar Shop', 'kubelio' ),
			'id'            => 'retheme_shop_sidebar',
			'before_widget' => '<div id="%1$s" class="rt-widget is-widget-aside is-widget-shop-aside %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="rt-block-heading"><h3 class="rt-block-heading__title has-medium-font-size">',
			'after_title'   => '</h3></div>',
		),
	);
}
add_action( 'widgets_init', 'rt_woocommerce_register_sidebar_widget' );

/**
 * Added plus/min icon on product quantity field
 */
function rt_woocommerce_quantity_button_minus() {
	$class = ( is_single() ) ? 'is-size-large' : '';
	if ( get_theme_mod( 'woocommerce_product_quantity_field', true ) ) {
		echo '<div class="rt-quantity js-quantity-increment ' . esc_attr( $class ) . '">';
		echo '<button type="button" class="rt-quantity__button increment-down" aria-label="' . esc_attr__( 'Decrease quantity', 'kubelio' ) . '">−</button>';
	}
}
function rt_woocommerce_quantity_button_plus() {
	if ( get_theme_mod( 'woocommerce_product_quantity_field', true ) ) {
		echo '<button type="button" class="rt-quantity__button increment-up" aria-label="' . esc_attr__( 'Increase quantity', 'kubelio' ) . '">+</button>';
		echo '</div>';
	}
}
add_action( 'woocommerce_before_quantity_input_field', 'rt_woocommerce_quantity_button_minus' );
add_action( 'woocommerce_after_quantity_input_field', 'rt_woocommerce_quantity_button_plus' );

/**
 * Remove quantity on sold individually products
 */
function rt_woocommerce_remove_quantity_cart_item( $product_quantity, $cart_item_key, $cart_item ) {
	$product = $cart_item['data'];

	if ( $product->is_sold_individually() ) {
		return '';
	}

	return $product_quantity;
}
add_filter( 'woocommerce_cart_item_quantity', 'rt_woocommerce_remove_quantity_cart_item', 10, 3 );

/**
 * Get cart count
 */
function rt_woocommerce_get_cart_count() {
	if ( WC()->cart ) {
		return '<span class="rt_cart_info_count">' . WC()->cart->get_cart_contents_count() . '</span>';
	}
	return 0;
}
