<?php

/**
 * WooCommerce shop template modifications
 *
 * @package Kubelio
 * @subpackage WooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Add overlay action on catalog view.
 *
 * Move add to cart button to thumbnail wrapper.
 * Remove default WooCommerce button.
 * Add custom button to thumbnail wrapper.
 */
// Remove default add to cart button position in catalog view.
if ( get_theme_mod( 'woocommerce_shop_catalog_style', 'button-overlay' ) === 'button-overlay' ) {
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 10 );
}

// Custom product thumbnail with overlay actions.
function rt_woocommerce_shop_custom_product_thumbnail() {
	if ( get_theme_mod( 'woocommerce_shop_catalog_style', 'button-overlay' ) === 'button-overlay' ) {
		global $product;

		echo '<div class="rt-product__thumbnail">';

		echo '<a href="' . esc_url( get_permalink( $product->get_id() ) ) . '" class="rt-product__image-link">';
		echo woocommerce_get_product_thumbnail();
		echo '</a>';

		// Product action buttons (add to cart).
		echo '<div class="rt-product__action">';
		woocommerce_template_loop_add_to_cart();
		echo '</div>';

		echo '</div>';
	}
}

// Added link to product title
function rt_woocommerce_loop_product_title() {
	if ( get_theme_mod( 'woocommerce_shop_catalog_style', 'button-overlay' ) === 'button-overlay' ) {
		global $product;

		echo '<h3 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title' ) ) . '">';
		echo '<a href="' . esc_url( get_permalink( $product->get_id() ) ) . '" class="rt-product__title-link has-heading-color">';
		echo esc_html( get_the_title() );
		echo '</a>';
		echo '</h3>';
	}
}

add_action( 'woocommerce_before_shop_loop_item_title', 'rt_woocommerce_shop_custom_product_thumbnail', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'rt_woocommerce_loop_product_title', 10 );

/**
 * Add custom class CSS to catalog products.
 */
function rt_woocommerce_shop_add_product_class( $classes, $product ) {
	$classes[] = 'rt-product';

	// Add overlay style class if button overlay is enabled in customizer.
	if ( get_theme_mod( 'woocommerce_shop_catalog_style', 'button-overlay' ) === 'button-overlay' ) {
		$classes[] = 'is-style-action-overlay';
	}

	return $classes;
}
add_filter( 'woocommerce_post_class', 'rt_woocommerce_shop_add_product_class', 10, 2 );

/**
 * Products per page
 */
function rt_woocommerce_shop_product_per_page( $per_page ) {

	// Adjust the number of products per page on mobile.
	// This ensures even numbers for stable layout on mobile devices.
	// This is done to maintain a stable layout on mobile devices, where items are displayed in two columns per row.
	if (
		wp_is_mobile() &&
		get_theme_mod( 'woocommerce_shop_catalog_stack_on_mobile', false ) &&
		get_theme_mod( 'woocommerce_shop_adjust_product_count_mobile', true )
	) {
		if ( $per_page % 2 !== 0 ) {
			++$per_page;
		}
		return $per_page;
	}

	// Set how many product per page based on customizer setting
	$product_per_page = get_theme_mod( 'woocommerce_shop_product_per_page', 12 );

	if ( $product_per_page !== null && $product_per_page !== '' ) {
		$per_page = (int) $product_per_page;
	}

	return $per_page;
}
add_filter( 'loop_shop_per_page', 'rt_woocommerce_shop_product_per_page', 20 );

/**
 * Add shop filter to footer
 */
function rt_woocommerce_shop_filter_render() {
	if ( rt_is_woocommerce( 'shop' ) && in_array( get_theme_mod( 'woocommerce_shop_layout', 'wide' ), array( 'wide', 'narrow', 'sidebar' ) ) ) {
		get_template_part( 'woocommerce/shop-filter' );
	}
}
add_action( 'wp_footer', 'rt_woocommerce_shop_filter_render' );
