<?php

/**
 * WooCommerce Product
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Replace Default Product Images
 *
 * Replace default product images with custom gallery swiper with glightbox
 */
function rt_woocommerce_product_images_remove() {
	if ( get_theme_mod( 'woocommerce_product_gallery_slider', true ) ) {
		remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
		remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );
	}
}

function rt_woocommerce_product_images_added() {
	if ( get_option( 'woocommerce_product_gallery_slider', true ) ) {
		get_template_part( 'woocommerce/single-product/gallery' );
	}
}
add_action( 'after_setup_theme', 'rt_woocommerce_product_images_remove' );
add_action( 'woocommerce_before_single_product_summary', 'rt_woocommerce_product_images_added', 10 );

/**
 * Wrap Product Sections
 *
 * Add custom HTML to wrap before product description, tabs, related products, upsells etc.
 */
function rt_woocommerce_product_sections_start() {
	echo '<div class="rt-product-sections wp-block-group is-layout-flow">';
}

function rt_woocommerce_product_sections_end() {
	echo '</div>';
}
add_action( 'woocommerce_after_single_product_summary', 'rt_woocommerce_product_sections_start', 1 );
add_action( 'woocommerce_after_single_product_summary', 'rt_woocommerce_product_sections_end', 99 );

/**
 * Remove Product Section Headings
 *
 * Remove description heading and additional information heading product tab.
 */
add_filter( 'woocommerce_product_description_heading', '__return_null' );
add_filter( 'woocommerce_product_additional_information_heading', '__return_null' );

/**
 * Wrap Product Price
 *
 * Wrap product price with custom HTML then move flash sale to price.
 */
function rt_woocommerce_product_wrap_price() {
	echo '<div class="rt-product-price">';
	woocommerce_template_single_price();
	woocommerce_show_product_sale_flash();
	echo '</div>';
}

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'rt_woocommerce_product_wrap_price', 10 );

/**
 * Social share
 */
function rt_woocommerce_product_social_share() {
	get_template_part( 'template-parts/single/share' );
}
add_action( 'woocommerce_share', 'rt_woocommerce_product_social_share', 20 );
