<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Wrap Order Review
 *
 * Start wrapper before "Your order" heading
 */
function rt_woocommerce_checkout_wrap_order_review_start() {
	echo '<div class="rt-checkout-order-review">';
}
function rt_woocommerce_checkout_wrap_order_review_end() {
	echo '</div>';
}
add_action( 'woocommerce_checkout_before_order_review_heading', 'rt_woocommerce_checkout_wrap_order_review_start', 5 );
add_action( 'woocommerce_checkout_after_order_review', 'rt_woocommerce_checkout_wrap_order_review_end', 20 );

/**
 * Move Coupon Form
 *
 * Move coupon form from top checkout page to review order tablet.
 */
function rt_woocommerce_checkout_move_coupon_form() {
	if ( wc_coupons_enabled() && get_theme_mod( 'woocommerce_checkout_move_coupon', true ) ) {
		echo '<div class="rt-review-order-coupon rt_review_order_coupon"></div>';
	}
}
add_action( 'woocommerce_review_order_before_payment', 'rt_woocommerce_checkout_move_coupon_form' );

/**
 * Move Cross Sell
 *
 * Move cross sell from bottom cart page to after cart table.
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart_table', 'woocommerce_cross_sell_display' );


/**
 * Checkout Custom Templates Checkout
 */
function rt_checkout_distraction_free_template( $template ) {
	// Check if we're on checkout page and not a WooCommerce endpoint
	if ( rt_is_woocommerce( array( 'cart', 'checkout', 'thank_page' ) ) && get_theme_mod( 'woocommerce_checkout_template_focus', true ) ) {
		// Path to custom template
		$custom_template = get_stylesheet_directory() . '/woocommerce/checkout-template.php';

		// Use custom template if file exists
		if ( file_exists( $custom_template ) ) {
			return $custom_template;
		}
	}
	return $template;
}
add_filter( 'template_include', 'rt_checkout_distraction_free_template', 99 );
