<?php

/**
 * Scripts and styles management
 *
 * This file handles the enqueuing of all CSS and JavaScript files
 * required by the theme. It ensures proper loading order and versioning
 * of assets for optimal performance and cache management.
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Enable loading separate core block assets
 */
function rt_scripts_enable_separate_core_block() {
	wp_enqueue_style( 'wp-block-columns' );
	wp_enqueue_style( 'wp-block-spacer' );
	wp_enqueue_style( 'wp-block-separator' );
	wp_enqueue_style( 'wp-block-social-links' );
	wp_enqueue_style( 'wp-block-group' );

	if ( is_single() ) {
		wp_enqueue_style( 'wp-block-comments' );
	}
}
add_action( 'wp_enqueue_scripts', 'rt_scripts_enable_separate_core_block' );

/**
 * Enqueue theme scripts and styles.
 *
 * This function is responsible for loading all the necessary CSS and JavaScript
 * files required by the theme. It handles both frontend and editor styles.
 */
function rt_scripts_register() {
	$theme_slug    = RT_THEME_SLUG;
	$theme_version = RT_THEME_VERSION;

	// Layout
	wp_enqueue_style( "{$theme_slug}-layout", get_template_directory_uri() . '/assets/css/layouts.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-layout", get_template_directory_uri() . '/assets/js/layout.min.js', false, $theme_version, true );

	// Utilities
	wp_enqueue_style( "{$theme_slug}-utilities", get_template_directory_uri() . '/assets/css/utilities.min.css', false, $theme_version );

	// Widget
	wp_enqueue_style( "{$theme_slug}-widget", get_template_directory_uri() . '/assets/css/elements/widget.min.css', false, $theme_version );

	// Navigation
	wp_enqueue_style( "{$theme_slug}-navigation", get_template_directory_uri() . '/assets/css/elements/navigation.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-navigation", get_template_directory_uri() . '/assets/js/navigation.min.js', array( 'animate' ), $theme_version, true );

	// Animate
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/animate/animate.min.css', false, '4.1.1' );
	wp_enqueue_script( 'animate', get_template_directory_uri() . '/assets/animate/animate.min.js', false, '1.0.0', true );

	// Swiper
	// This theme requires using Swiper v12 for fixing the image product sliders.s
	// Only use Swiper v12 for the single product page.
	if ( rt_is_woocommerce( 'product' ) && get_option( 'swiper_version', 'v12' ) === 'v12' ) {
		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/assets/swiper/v12/swiper-bundle.min.css', false, '12.0.3' );
		wp_enqueue_script( 'swiper', get_template_directory_uri() . '/assets/swiper/v12/swiper-bundle.min.js', false, '12.0.3', true );
	} else {
		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/assets/swiper/v8/swiper-bundle.min.css', false, '8.4.7' );
		wp_enqueue_script( 'swiper', get_template_directory_uri() . '/assets/swiper/v8/swiper-bundle.min.js', false, '8.4.5', true );
	}

	wp_enqueue_style( "{$theme_slug}-swiper", get_template_directory_uri() . '/assets/css/elements/retheme-swiper.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-swiper", get_template_directory_uri() . '/assets/js/retheme-swiper.min.js', array( 'swiper' ), $theme_version, true );

	// Slide panel
	wp_enqueue_style( "{$theme_slug}-slidepanel", get_template_directory_uri() . '/assets/css/elements/slidepanel.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-slidepanel", get_template_directory_uri() . '/assets/js/slidepanel.min.js', array( 'animate' ), $theme_version, true );

	// Modal
	wp_enqueue_style( "{$theme_slug}-modal", get_template_directory_uri() . '/assets/css/elements/modal.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-modal", get_template_directory_uri() . '/assets/js/modal.min.js', array( 'animate' ), $theme_version, true );

	 // Plugins
    if (defined('ELEMENTOR_VERSION')) {
        wp_enqueue_style('retheme-elementor', get_template_directory_uri() . '/assets/css/plugins/elementor.min.css', false, '1.0.0');
    }

    if (defined('WPCF7_VERSION')) {
        wp_enqueue_style('retheme-contact-form-7', get_template_directory_uri() . '/assets/css/plugins/contact-form-7.min.css', false, '1.0.0');
    }

    if (defined('TUTOR_VERSION')) {
        wp_enqueue_style('retheme-tutor-lms', get_template_directory_uri() . '/assets/css/plugins/tutor-lms.min.css', false, '1.0.0');
    }

	// Comment
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_style( "{$theme_slug}-comment", get_template_directory_uri() . '/assets/css/comment-style.min.css', false, $theme_version );
		wp_enqueue_script( 'comment-reply' );
	}

	// Main style
	wp_enqueue_style( "{$theme_slug}-global", get_template_directory_uri() . '/assets/css/style.min.css', false, $theme_version );
	wp_enqueue_script( "{$theme_slug}-global", get_template_directory_uri() . '/assets/js/main.min.js', false, $theme_version, true );

	// Theme
	wp_enqueue_style( $theme_slug, get_template_directory_uri() . '/assets/css/theme.min.css', false, $theme_version );
	wp_enqueue_script( $theme_slug, get_template_directory_uri() . '/assets/js/theme.min.js', false, $theme_version, true );
}
add_action( 'wp_enqueue_scripts', 'rt_scripts_register', 9999 );
