<?php

/**
 * Post-related functionality and customizations
 *
 * This file contains functions that modify and enhance the default
 * WordPress post behavior, including excerpts, reading time calculations,
 * post views, and other post-related functionality.
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Remove prefix from archive titles
 *
 * Removes the default 'Category:', 'Tag:', etc. prefixes from archive titles
 */
function rt_post_archive_remove_prefix_title( $title ) {
	$title = single_cat_title( '', false );

	return $title;
}
add_filter( 'get_the_archive_title', 'rt_post_archive_remove_prefix_title' );

/**
 * Change symbol excerpt more
 */
function rt_post_custom_excerpt_more( $more ) {
	return '...';
}
add_filter( 'excerpt_more', 'rt_post_custom_excerpt_more' );
