<?php
/**
 * Menu functionality and enhancements
 *
 * This file contains functions that enhance the WordPress menu system,
 * including custom menu walkers, menu item modifications, and other
 * menu-related functionality.
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Menu arrow
 *
 * Add arrow to menu items with children
 *
 * @param $item_output
 * @param $item
 * @param $depth
 * @param $args
 * @return html
 */
function rt_menu_add_arrow( $item_output, $item, $depth, $args ) {
	if ( in_array( 'menu-item-has-children', $item->classes ) ) {
		// append icon
		$item_output .= '<span class="rt-menu-arrow"><i class="rt-icon"><svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor" class="bi bi-chevron-down" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/>
      </svg></i></span>';
	}

	return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'rt_menu_add_arrow', 10, 4 );


/**
 * Set default menu item
 */
function rt_menu_default() {

	$link = '<ul class="rt-menu-default">';
	if ( current_user_can( 'manage_options' ) ) {
		$link .= '<li class="menu-item is-active"><a href="' . admin_url( 'nav-menus.php' ) . '">Edit Menu</a></li>';
	}
	$link .= '<li class="menu-item"><a>Sample Menu</a></li>';
	$link .= '<li class="menu-item"><a>Sample Menu</a></li>';
	$link .= '<li class="menu-item"><a>Sample Menu</a></li>';
	$link .= '<ul>';

	echo $link;
}
