<?php

/**
 * Block Editor (Gutenberg) related functionality
 *
 * This file contains functions that enhance the WordPress Block Editor (Gutenberg)
 * experience. It includes editor styles, admin classes, and customizer integration
 * for the block editor.
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Add editor styles
 */
function rt_block_editor_style() {
	add_theme_support( 'editor-styles' );
	add_editor_style( 'assets/css/utilities.min.css' );
	add_editor_style( 'assets/css/style.min.css' );
	add_editor_style( 'assets/css/theme.min.css' );
	add_editor_style( 'assets/css/elements/retheme-swiper.min.css' );
	add_editor_style( 'assets/css/editor-style.min.css' );
}
add_action( 'after_setup_theme', 'rt_block_editor_style', 99 );

/**
 * Add admin classes
 */
function rt_block_admin_classes( $classes ) {

	$classes = 'retheme-root retheme-default-scheme';

	return $classes;
}
add_filter( 'admin_body_class', 'rt_block_admin_classes' );

/**
 * Custom color palette from customizer
 */
function rt_block_customizer( $theme_json ) {
	$theme_data      = json_decode( file_get_contents( get_stylesheet_directory() . '/theme.json' ), true );
	$default_palette = $theme_data['settings']['color']['palette'] ?? array();

	$custom_palette = array(
		array(
			'slug'  => 'primary',
			'color' => get_theme_mod( 'global_color_primary', rt_get_theme( 'color' )['primary'] ),
			'name'  => 'Primary',
		),
		array(
			'slug'  => 'heading',
			'color' => get_theme_mod( 'global_color_heading', rt_get_theme( 'color' )['heading'] ),
			'name'  => 'Heading',
		),
		array(
			'slug'  => 'body',
			'color' => get_theme_mod( 'global_color_body', rt_get_theme( 'color' )['body'] ),
			'name'  => 'body',
		),
		array(
			'slug'  => 'meta',
			'color' => get_theme_mod( 'global_color_meta', rt_get_theme( 'color' )['meta'] ),
			'name'  => 'Meta',
		),
		array(
			'slug'  => 'text-link',
			'color' => get_theme_mod( 'global_color_link', rt_get_theme( 'color' )['text-link'] ),
			'name'  => 'Link',
		),
		array(
			'slug'  => 'text-link-active',
			'color' => get_theme_mod( 'global_color_link_active', rt_get_theme( 'color' )['text-link-active'] ),
			'name'  => 'Link Active',
		),
		array(
			'slug'  => 'background',
			'color' => get_theme_mod( 'global_color_background', rt_get_theme( 'color' )['background'] ),
			'name'  => 'Background',
		),
		array(
			'slug'  => 'foreground',
			'color' => get_theme_mod( 'global_color_foreground', rt_get_theme( 'color' )['foreground'] ),
			'name'  => 'Foreground',
		),
		array(
			'slug'  => 'outline',
			'color' => get_theme_mod( 'global_color_border', rt_get_theme( 'color' )['outline'] ),
			'name'  => 'Outline',
		),
	);

	$new_data = array(
		'version'  => 3,
		'settings' => array(
			'color'      => array(
				'palette' => array_replace( $default_palette, $custom_palette ),
			),
			'typography' => array(
				'fontFamilies' => array(
					array(
						'slug'       => 'heading',
						'fontFamily' => get_theme_mod( 'typography_heading', rt_get_theme( 'typography' )['heading'] )['font-family'] ?? rt_get_theme( 'typography' )['heading']['font-family'],
						'name'       => 'Heading',
					),
					array(
						'slug'       => 'body',
						'fontFamily' => get_theme_mod( 'typography_body', rt_get_theme( 'typography' )['body'] )['font-family'] ?? rt_get_theme( 'typography' )['body']['font-family'],
						'name'       => 'Body',
					),
				),
			),
		),
	);

	return $theme_json->update_with( $new_data );
}
add_filter( 'wp_theme_json_data_theme', 'rt_block_customizer' );
