<?php

/**
 * Control for WooCommerce
 *
 * @since 1.0.0
 */

namespace Retheme\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WooCommerce extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->add_shop();
		$this->add_checkout();
	}

	public function add_shop() {
		$section = 'woocommerce_product_catalog';

		$this->add_field(
			array(
				'type'        => 'number',
				'label'       => esc_html__( 'Product Per Page', 'kubelio' ),
				'settings'    => 'woocommerce_shop_product_per_page',
				'description' => esc_html__( 'Set the number of products per page (Max 100)', 'kubelio' ),
				'section'     => $section,
				'default'     => 12,
				'priority'    => 200,
				'input_attrs' => array(
					'min' => 1,
					'max' => 100,
				),
			)
		);

		$this->add_field(
			array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Stack On Mobile', 'kubelio' ),
				'settings'    => 'woocommerce_shop_catalog_stack_on_mobile',
				'description' => esc_html__( 'Show one product per row on mobile', 'kubelio' ),
				'section'     => $section,
				'default'     => false,
				'priority'    => 210,
			)
		);

		$this->add_field(
			array(
				'type'            => 'toggle',
				'label'           => esc_html__( 'Adjust Product Count for Mobile', 'kubelio' ),
				'settings'        => 'woocommerce_shop_adjust_product_count_mobile',
				'description'     => esc_html__( 'Keeps the mobile shop layout in perfect 2-column balance by forcing an even number of products per page.', 'kubelio' ),
				'section'         => $section,
				'default'         => true,
				'priority'        => 220,
				'active_callback' => array(
					array(
						'setting'  => 'woocommerce_shop_catalog_stack_on_mobile',
						'operator' => '===',
						'value'    => false,
					),
				),
			)
		);

		if ( rt_fs()->can_use_premium_code() ) {
			$this->add_field(
				array(
					'type'     => 'select',
					'label'    => esc_html__( 'Products Style', 'kubelio' ),
					'settings' => 'woocommerce_shop_catalog_style',
					'section'  => $section,
					'default'  => 'button-overlay',
					'priority' => 230,
					'choices'  => array(
						'default'        => esc_html__( 'Default', 'kubelio' ),
						'button-overlay' => esc_html__( 'Button Overlay', 'kubelio' ),
					),
				)
			);

			$this->add_field(
				array(
					'type'     => 'select',
					'label'    => esc_html__( 'Shop Layout', 'kubelio' ),
					'settings' => 'woocommerce_shop_layout',
					'section'  => $section,
					'default'  => 'wide',
					'priority' => 240,
					'choices'  => array(
						'wide'          => esc_html__( 'Wide', 'kubelio' ),
						'sidebar'       => esc_html__( 'Sidebar', 'kubelio' ),
						'sidebar-stack' => esc_html__( 'Sidebar Stack', 'kubelio' ),
					),
				)
			);
		}
	}

	public function add_checkout() {

		$section = 'woocommerce_checkout';

		$this->add_divinder(
			array(
				'section' => $section,
			),
		);

		$this->add_field(
			array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Distraction-Free Checkout', 'kubelio' ),
				'description' => sprintf(
					wp_kses_post( __( 'Create a clean cart and checkout experience by hiding header elements to minimize distractions. You can change the checkout logo in the <a href="%s">Logo Options</a>.', 'kubelio' ) ),
					"javascript:wp.customize.control( 'brand_logo_checkout' ).focus();"
				),
				'settings'    => 'woocommerce_checkout_template_focus',
				'section'     => $section,
				'default'     => false,
			),
		);
	}

	// end class
}

new WooCommerce();
