<?php

/**
 * Control for post
 *
 * @since 1.0.0
 */

namespace Retheme\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Post extends \Retheme\Customizer_Base {
	public function __construct() {
		$this->set_section();

		// archive section
		$this->add_post_options();

		// single section
		$this->add_single_options();

		$this->add_single_related();
	}

	public function set_section() {

		$this->add_section(
			'post',
			array(
				'title'    => esc_html__( 'Post', 'kubelio' ),
				'priority' => 80,
			)
		);
	}

	public function add_post_options() {
		$section = 'post';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Post Loops', 'kubelio' ),
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'post_element_category',
				'label'    => esc_html__( 'Categories', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'post_element_content',
				'label'    => esc_html__( 'Excerpt', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'multicheck',
				'settings' => 'post_meta',
				'label'    => esc_html__( 'Post Meta', 'kubelio' ),
				'section'  => $section,
				'default'  => array(
					'meta-date',
					'meta-comment',
				),
				'multiple' => 999,
				'choices'  => array(
					'meta-author'  => esc_html__( 'Author', 'kubelio' ),
					'meta-date'    => esc_html__( 'Date', 'kubelio' ),
					'meta-comment' => esc_html__( 'Comment', 'kubelio' ),
				),
			)
		);

		$this->add_field(
			array(
				'type'        => 'number',
				'option_type' => 'option',
				'settings'    => 'posts_per_page',
				'label'       => esc_html__( 'Posts Per Page', 'kubelio' ),
				'description' => esc_html__( 'Choose how many posts will appear.', 'kubelio' ),
				'section'     => $section,
				'default'     => 6,
			)
		);
	}

	public function add_single_options() {
		$section = 'post';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Single Post', 'kubelio' ),
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_category',
				'label'    => esc_html__( 'Categories', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_thumbnail',
				'label'    => esc_html__( 'Featured Image', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_sharebox',
				'label'    => esc_html__( 'Social Share Box', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_tag',
				'label'    => esc_html__( 'Tags', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_authorbox',
				'label'    => esc_html__( 'Author Info Box', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'single_element_comment',
				'label'    => esc_html__( 'Comments', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'multicheck',
				'settings' => 'single_meta',
				'label'    => esc_html__( 'Post Meta', 'kubelio' ),
				'section'  => $section,
				'default'  => array(
					'meta-date',
					'meta-comment',
				),
				'multiple' => 999,
				'choices'  => array(
					'meta-author'  => esc_html__( 'Author', 'kubelio' ),
					'meta-date'    => esc_html__( 'Date', 'kubelio' ),
					'meta-comment' => esc_html__( 'Comment', 'kubelio' ),
				),
			)
		);
	}

	public function add_single_related() {

		if ( rt_fs()->can_use_premium_code() ) {
			$section = 'post';

			$this->add_divinder(
				array(
					'section' => $section,
				)
			);

			$this->add_field(
				array(
					'type'     => 'toggle',
					'settings' => 'single_related',
					'label'    => esc_html__( 'Related Posts', 'kubelio' ),
					'section'  => $section,
					'default'  => 1,
				)
			);

			$this->add_field(
				array(
					'type'            => 'number',
					'settings'        => 'single_related_count',
					'label'           => esc_html__( 'Number of Related Posts', 'kubelio' ),
					'description'     => esc_html__( 'Choose how many related posts will appear.', 'kubelio' ),
					'section'         => $section,
					'default'         => 6,
					'active_callback' => array(
						array(
							'setting'  => 'single_related',
							'operator' => '===',
							'value'    => true,
						),
					),
				)
			);
		}
	}

	// end class
}

new Post();
