<?php

/**
 * Control for header
 *
 * @since 1.0.0
 */

namespace Retheme\Customizer;

use Kirki\Pro\Control\Divider;
use Kirki\Pro\Field\Divider as FieldDivider;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Header extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->set_section();
		$this->add_header_global();
		$this->add_header_styles();
		$this->add_button();
	}

	public function set_section() {

		$this->add_section(
			'header',
			array(
				'title'       => esc_html__( 'Header', 'kubelio' ),
				'description' => sprintf(
					wp_kses_post( __( 'Go to the <a href="%s">Logo settings</a> to change your logo.', 'kubelio' ) ),
					"javascript:wp.customize.section( 'title_tagline' ).focus();"
				),
				'priority'    => 60,
			)
		);
	}

	public function add_header_global() {
		$section = 'header';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Global Options', 'kubelio' ),
				'section' => $section,
			)
		);

		if ( rt_fs()->can_use_premium_code() ) {
			$this->add_field(
				array(
					'type'        => 'select',
					'label'       => esc_html__( 'Sticky Header', 'kubelio' ),
					'description' => esc_html__( 'Choose how the header behaves when scrolling.', 'kubelio' ),
					'settings'    => 'header_sticky',
					'section'     => $section,
					'default'     => 'up',
					'choices'     => array(
						'none' => esc_html__( 'Disable Sticky Header', 'kubelio' ),
						'up'   => esc_html__( 'Sticky on Scroll Up', 'kubelio' ),
						'down' => esc_html__( 'Sticky on Scroll Down', 'kubelio' ),
					),
				)
			);

			$this->add_divinder(
				array(
					'section' => $section,
				),
			);
		}

		$this->add_field(
			array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Search', 'kubelio' ),
				'description' => esc_html__( 'Display the search icon to open the search popup and form search on mobile menu.', 'kubelio' ),
				'settings'    => 'header_search_icon',
				'section'     => $section,
				'default'     => true,
			),
		);

		$this->add_field(
			array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Account', 'kubelio' ),
				'description' => esc_html__( 'Display the account link to redirect users to their account page.', 'kubelio' ),
				'settings'    => 'header_account_icon',
				'section'     => $section,
				'default'     => true,
			),
		);

		$this->add_field(
			array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Cart', 'kubelio' ),
				'description' => esc_html__( 'Display the cart icon to open the mini cart slide off canvas.', 'kubelio' ),
				'settings'    => 'header_cart_icon',
				'section'     => $section,
				'default'     => true,
			),
		);
	}



	public function add_header_styles() {
		$section = 'header';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Styles', 'kubelio' ),
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'settings'  => 'header_color',
				'default'   => rt_get_theme( 'color' )['body'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.site-header__main, 
                                .site-header-mobile__main',
						'property' => '--wp--preset--color--body',
					),
					array(
						'element'  => '.site-header__main, 
                                .site-header-mobile__main',
						'property' => '--wp--preset--color--text-link-active',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'settings'  => 'header_background',
				'default'   => rt_get_theme( 'color' )['background'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.site-header__main, 
                                .site-header-mobile__main',
						'property' => '--wp--preset--color--background',
					),
				),
			)
		);
	}

	public function add_button() {

		if ( rt_fs()->can_use_premium_code() ) {

			$section = 'header';

			$this->add_header(
				array(
					'label'   => esc_html__( 'Custom Button', 'kubelio' ),
					'section' => $section,
				)
			);

			$this->add_field(
				array(
					'type'        => 'toggle',
					'label'       => esc_html__( 'Header Button', 'kubelio' ),
					'description' => esc_html__( 'Adds a custom button to the right side of the desktop header. On mobile, the button automatically moves to the off-canvas menu.', 'kubelio' ),
					'settings'    => 'header_button',
					'section'     => $section,
					'default'     => false,
				)
			);

			$this->add_field(
				array(
					'type'            => 'text',
					'label'           => esc_html__( 'Button Label', 'kubelio' ),
					'description'     => esc_html__( 'Enter the text to display on the header button.', 'kubelio' ),
					'settings'        => 'header_button_text',
					'section'         => $section,
					'default'         => esc_html__( 'Get Started', 'kubelio' ),
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);

			$this->add_field(
				array(
					'type'            => 'text',
					'label'           => esc_html__( 'Button Link', 'kubelio' ),
					'description'     => esc_html__( 'Enter the URL for the header button.', 'kubelio' ),
					'settings'        => 'header_button_url',
					'section'         => $section,
					'default'         => '#',
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);

			$this->add_field(
				array(
					'type'            => 'checkbox',
					'label'           => esc_html__( 'Open link in a new tab', 'kubelio' ),
					'description'     => esc_html__( 'Check this option to open the button link in a new browser tab.', 'kubelio' ),
					'settings'        => 'header_button_target',
					'section'         => $section,
					'default'         => false,
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);

			$this->add_divinder(
				array(
					'section'         => $section,
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);

			$this->add_field(
				array(
					'type'            => 'color',
					'choices'         => array( 'alpha' => true ),
					'label'           => esc_html__( 'Text Color', 'kubelio' ),
					'settings'        => 'header_button_color',
					'default'         => rt_get_theme( 'button' )['primary']['color'],
					'section'         => $section,
					'transport'       => 'auto',
					'output'          => array(
						array(
							'element'  => '.site-header__middle, .site-header__main',
							'property' => '--wp--custom--button--color',
						),
						array(
							'element'  => '#offcanvas_mobile_menu',
							'property' => '--wp--custom--button--color',
						),
					),
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);

			$this->add_field(
				array(
					'type'            => 'color',
					'choices'         => array( 'alpha' => true ),
					'label'           => esc_html__( 'Background Color', 'kubelio' ),
					'settings'        => 'header_background_color',
					'default'         => rt_get_theme( 'button' )['primary']['background'],
					'section'         => $section,
					'transport'       => 'auto',
					'output'          => array(
						array(
							'element'  => '.site-header__middle, .site-header__main',
							'property' => '--wp--custom--button--background',
						),
						array(
							'element'  => '#offcanvas_mobile_menu',
							'property' => '--wp--custom--button--background',
						),
					),
					'active_callback' => array(
						array(
							'setting'  => 'header_button',
							'operator' => '==',
							'value'    => true,
						),
					),
				)
			);
		}
	}
	// end class
}

new Header();
