<?php

/**
 * Control for general
 *
 * @since 1.0.0
 */

namespace Retheme\Customizer;

use Kirki\Module\Tooltips;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class General extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->set_section();
		$this->add_typography();
		$this->add_color();
		$this->add_button();
		$this->add_off_canvas();
		$this->add_element();
	}

	public function set_section() {
		$this->add_panel(
			'general',
			array(
				'title'    => esc_html__( 'Global', 'kubelio' ),
				'priority' => 50,
			)
		);

		$this->add_section(
			'general_typography',
			array(
				'title'    => esc_html__( 'Typography', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 10,
			)
		);

		$this->add_section(
			'general_color',
			array(
				'title'    => esc_html__( 'Colors & Styles', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 15,
			)
		);

		$this->add_section(
			'general_button',
			array(
				'title'    => esc_html__( 'Button', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 20,
			)
		);

		$this->add_section(
			'general_menu',
			array(
				'title'    => esc_html__( 'Sub Menu', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 25,
			)
		);

		$this->add_section(
			'general_off_canvas_panel',
			array(
				'title'       => esc_html__( 'Off-Canvas Area', 'kubelio' ),
				'description' => esc_html__( 'This option applies to sub menus and dropdown menus on mobile.', 'kubelio' ),
				'panel'       => 'general',
				'priority'    => 30,
			)
		);

		$this->add_section(
			'general_element',
			array(
				'title'    => esc_html__( 'Element', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 35,
			)
		);

		$this->add_section(
			'general_post_ticker',
			array(
				'title'    => esc_html__( 'Post Ticker', 'kubelio' ),
				'panel'    => 'general',
				'priority' => 40,
			)
		);
	}

	public function add_typography() {
		$section = 'general_typography';

		$this->add_field(
			array(
				'type'     => 'typography',
				'settings' => 'typography_heading',
				'label'    => esc_html__( 'Headings', 'kubelio' ),
				'section'  => $section,
				'default'  => rt_get_theme( 'typography' )['heading'],
				'output'   => array(
					array(
						'choice'   => 'font-family',
						'element'  => 'body',
						'property' => '--wp--preset--font-family--heading',
					),
					array(
						'choice'   => 'variant',
						'element'  => 'h1, h2, h3, h4, h5, h6',
						'property' => 'font-weight',
					),
				),
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'typography',
				'settings' => 'typography_body',
				'label'    => esc_html__( 'Body', 'kubelio' ),
				'section'  => $section,
				'default'  => rt_get_theme( 'typography' )['body'],
				'output'   => array(
					array(
						'choice'   => 'font-family',
						'element'  => 'body',
						'property' => '--wp--preset--font-family--body',
					),
					array(
						'choice'   => 'variant',
						'element'  => 'body',
						'property' => 'font-weight',
					),
				),
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'typography',
				'settings' => 'typography_navigation',
				'label'    => esc_html__( 'Primary Navigation', 'kubelio' ),
				'section'  => $section,
				'default'  => rt_get_theme( 'typography' )['menu'],
				'output'   => array(
					array(
						'choice'   => 'font-family',
						'element'  => '.site-header .rt-menu, .site-header-mobile .rt-menu',
						'property' => 'font-family',
					),
					array(
						'choice'   => 'variant',
						'element'  => '.site-header .rt-menu, .site-header-mobile .rt-menu',
						'property' => 'font-weight',
					),
				),
			)
		);
	}

	public function add_color() {
		$section = 'general_color';

		// Brand
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Primary Color', 'kubelio' ),
				'settings'  => 'global_color_primary',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['primary'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--primary',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		// Font Color
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Heading Color', 'kubelio' ),
				'settings'  => 'global_color_heading',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['heading'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--heading',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'settings'  => 'global_color_body',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['body'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--body',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Meta Color', 'kubelio' ),
				'settings'  => 'global_color_meta',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['meta'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--meta',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		// Link
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Link Color', 'kubelio' ),
				'settings'  => 'global_color_link',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['text-link'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--text-link',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'        => 'color',
				'choices'     => array( 'alpha' => true ),
				'label'       => esc_html__( 'Link Accent Color', 'kubelio' ),
				'description' => esc_html__( 'Set the color when hovering over the element.', 'kubelio' ),
				'settings'    => 'global_color_link_active',
				'section'     => $section,
				'default'     => rt_get_theme( 'color' )['text-link'],
				'output'      => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--text-link-active',
					),
				),
				'transport'   => 'auto',
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		// Background
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'settings'  => 'global_color_background',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['background'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--background',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Foreground Color', 'kubelio' ),
				'settings'  => 'global_color_foreground',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['foreground'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--foreground',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		// Border Color
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Border Color', 'kubelio' ),
				'settings'  => 'global_color_border',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['outline'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--outline',
					),
				),
				'transport' => 'auto',
			)
		);

		// Hightlight Color
		$this->add_divinder(
			array(
				'section' => $section,
			)
		);

		// Hightlight Color
		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Hightlight Color', 'kubelio' ),
				'settings'  => 'global_color_hightlight',
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['highlight'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--preset--color--highlight',
					),
				),
				'transport' => 'auto',
			)
		);
	}

	public function add_button() {
		$section = 'general_button';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Button Primary', 'kubelio' ),
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'settings'  => 'global_button_color',
				'section'   => $section,
				'default'   => rt_get_theme( 'button' )['primary']['color'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--custom--button--color',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'settings'  => 'global_button_background',
				'section'   => $section,
				'default'   => rt_get_theme( 'button' )['primary']['background'],
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--custom--button--background',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_header(
			array(
				'label'   => esc_html__( 'Button Action', 'kubelio' ),
				'section' => $section,
				'tooltip' => esc_html__( 'Applies to buttons like add to cart and checkout.', 'kubelio' ),
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'settings'  => 'global_button_action_color',
				'default'   => rt_get_theme( 'button' )['action']['color'],
				'section'   => $section,
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--custom--button-action--color',
					),
				),
				'transport' => 'auto',
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'settings'  => 'global_button_action_background',
				'default'   => rt_get_theme( 'button' )['action']['background'],
				'section'   => $section,
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme',
						'property' => '--wp--custom--button-action--background',
					),
				),
				'transport' => 'auto',
			)
		);
	}

	public function add_off_canvas() {

		$section = 'general_off_canvas_panel';

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'offcanvas_color',
				'default'   => rt_get_theme( 'color' )['body-alt'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .rt-offcanvas-mobile-menu',
						'property' => '--wp--preset--color--body',
					),
					array(
						'element'  => '.retheme-default-scheme .site-header .sub-menu',
						'property' => '--menu-color',
					),
				),

			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'offcanvas_background',
				'default'   => rt_get_theme( 'color' )['background-alt'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .rt-offcanvas-mobile-menu',
						'property' => '--wp--preset--color--background',
					),
					array(
						'element'  => '.retheme-default-scheme .site-header .sub-menu',
						'property' => '--wp--preset--color--background',
					),
				),

			)
		);
	}

	public function add_element() {

		$section = 'general_element';

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'breadcrumbs',
				'label'    => esc_html__( 'Breadcrumbs', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
				'default'  => true,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'gotop',
				'label'    => esc_html__( 'Go Top Navigation', 'kubelio' ),
				'default'  => true,
				'section'  => $section,
				'default'  => true,
			)
		);
	}

	// end class
}

new General();
