<?php

/**
 * Control for footer
 *
 * @since 1.0.0
 */

namespace Retheme\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Footer extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->set_section();
		$this->add_footer();
	}

	public function set_section() {

		$this->add_section(
			'footer',
			array(
				'title' => esc_html__( 'Footer', 'kubelio' ),
			)
		);
	}

	public function add_footer() {
		$section = 'footer';

		$this->add_header(
			array(
				'label'   => esc_html__( 'Footer Options', 'kubelio' ),
				'section' => $section,
			)
		);

		$footer_layout_choices = array(
			'footer-copyright-social'   => get_template_directory_uri() . '/core/customizer/assets/img/footer-copyright-social.webp',
			'footer-copyright-menu'     => get_template_directory_uri() . '/core/customizer/assets/img/footer-copyright-menu.webp',
			'footer-column-3-big-first' => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-3-big-first.webp',
			'footer-column-4-equal'     => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-4-equal.webp',
		);

		if ( rt_fs()->can_use_premium_code() ) {
			$footer_layout_choices = array(
				'footer-copyright-social'    => get_template_directory_uri() . '/core/customizer/assets/img/footer-copyright-social.webp',
				'footer-copyright-menu'      => get_template_directory_uri() . '/core/customizer/assets/img/footer-copyright-menu.webp',
				'footer-column-1-center'     => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-1-center.webp',
				'footer-column-3-equal'      => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-3-equal.webp',
				'footer-column-3-big-first'  => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-3-big-first.webp',
				'footer-column-3-big-center' => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-3-big-center.webp',
				'footer-column-4-equal'      => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-4-equal.webp',
				'footer-column-4-big-first'  => get_template_directory_uri() . '/core/customizer/assets/img/footer-column-4-big-first.webp',
			);
		}

		$this->add_field(
			array(
				'type'        => 'radio-image',
				'section'     => $section,
				'settings'    => 'footer_widget_layout',
				'label'       => esc_html__( 'Layout', 'kubelio' ),
				'description' => sprintf(
					wp_kses_post( __( 'Visit the <a href="%s">Widgets panel</a> and add a widget to display a element on footer.', 'kubelio' ) ),
					"javascript:wp.customize.panel( 'widgets' ).focus();"
				),
				'default'     => 'footer-copyright-social',
				'choices'     => $footer_layout_choices,
			)
		);

		$this->add_field(
			array(
				'type'        => 'textarea',
				'label'       => esc_html__( 'Copyright (Support HTML tag)', 'kubelio' ),
				'settings'    => 'footer_bottom_text',
				'description' => esc_html__( 'You can use text map {{site_name}} {{year}}', 'kubelio' ),
				'section'     => $section,
				'default'     => '@Copyright {{site_name}}. All Rights Reserved',
			)
		);

		$this->add_header(
			array(
				'label'   => esc_html__( 'Footer Styles', 'kubelio' ),
				'section' => $section,
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Heading Color', 'kubelio' ),
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'footer_widget_heading_color',
				'default'   => rt_get_theme( 'color' )['heading-alt'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--heading',
					),
				),

			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Text Color', 'kubelio' ),
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'footer_widget_color',
				'default'   => rt_get_theme( 'color' )['body-alt'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--body',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'label'     => esc_html__( 'Meta Color', 'kubelio' ),
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'footer_widget_meta_color',
				'default'   => rt_get_theme( 'color' )['meta-alt'],
				'section'   => $section,
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--meta',
					),
				),

			)
		);

		$this->add_field(
			array(
				'type'        => 'color',
				'choices'     => array( 'alpha' => true ),
				'settings'    => 'footer_widget_color_active',
				'label'       => esc_html__( 'Accent Color', 'kubelio' ),
				'description' => esc_html__( 'Set the color when hovering over the element.', 'kubelio' ),
				'section'     => $section,
				'default'     => '#ffffff',
				'transport'   => 'auto',
				'output'      => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--text-link-active',
					),
				),

			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'footer_widget_background',
				'label'     => esc_html__( 'Background Color', 'kubelio' ),
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['background-alt'],
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--foreground',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'color',
				'choices'   => array( 'alpha' => true ),
				'settings'  => 'footer_widget_border_color',
				'label'     => esc_html__( 'Border Color', 'kubelio' ),
				'section'   => $section,
				'default'   => rt_get_theme( 'color' )['outline-alt'],
				'transport' => 'auto',
				'output'    => array(
					array(
						'element'  => '.retheme-default-scheme .site-footer',
						'property' => '--wp--preset--color--outline',
					),
				),
			)
		);
	}

	// end class
}
new Footer();
