<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once __DIR__ . '/class-customizer-base.php';

/**
 * Register theme mod
 */
function rt_register_customizer_type() {
	\Kirki::add_config(
		'retheme_customizer',
		array(
			'capability'  => 'edit_theme_options',
			'option_type' => 'theme_mod',
		)
	);
}
add_action( 'customize_register', 'rt_register_customizer_type' );

/**
 * Remove frontpage section
 */
function rt_customizer_remove_sections( $wp_customize ) {
	$wp_customize->remove_section( 'static_front_page' );
}
add_action( 'customize_register', 'rt_customizer_remove_sections' );

/**
 * Register control section
 */
function rt_customizer_include_part() {
	include __DIR__ . '/general.php';
	include __DIR__ . '/brand.php';
	include __DIR__ . '/header.php';
	include __DIR__ . '/footer.php';
	include __DIR__ . '/post.php';
	include __DIR__ . '/connect.php';
	include __DIR__ . '/woocommerce.php';

	do_action( 'retheme_customizer_register' );
}
add_action( 'after_setup_theme', 'rt_customizer_include_part' );

/**
 * Register customizer control scripts
 */
function rt_customizer_control_scripts() {
	wp_enqueue_style( 'retheme-customizer-panel', get_template_directory_uri() . '/core/customizer/assets/css/customizer-panel.css', false, '3.0.0' );
}
add_action( 'customize_controls_enqueue_scripts', 'rt_customizer_control_scripts', 999 );

/**
 * Register customizer preview scripts
 */
function rt_customizer_preview_scripts() {
	wp_enqueue_style( 'retheme-customizer-preview', get_template_directory_uri() . '/core/customizer/assets/css/customizer-preview.css', false, '3.0.0' );
}
add_action( 'customize_preview_init', 'rt_customizer_preview_scripts' );
