<?php
/**
 * Control for social media and share
 *
 * @since 1.0.0
 */
namespace Retheme\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Connect extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->set_section();
		$this->add_socmed();
		$this->add_share();
	}

	public function set_section() {

		$this->add_panel(
			'connect',
			array(
				'title' => esc_html__( 'Connect', 'kubelio' ),
			)
		);

		$this->add_section(
			'social',
			array(
				'title' => esc_html__( 'Social Links', 'kubelio' ),
				'panel' => 'connect',
			)
		);

		$this->add_section(
			'share',
			array(
				'title' => esc_html__( 'Social Share', 'kubelio' ),
				'panel' => 'connect',
			)
		);
	}

	public function add_socmed() {

		$section = 'social';

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_facebook',
				'label'    => esc_html__( 'Facebook', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_instagram',
				'label'    => esc_html__( 'Instagram', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_youtube',
				'label'    => esc_html__( 'Youtube', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_twitter',
				'label'    => esc_html__( 'Twitter', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_pinterest',
				'label'    => esc_html__( 'Pinterest', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_tiktok',
				'label'    => esc_html__( 'Tiktok', 'kubelio' ),
				'default'  => '#',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_github',
				'label'    => esc_html__( 'GitHub', 'kubelio' ),
				'default'  => '',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_gitlab',
				'label'    => esc_html__( 'GitLab', 'kubelio' ),
				'default'  => '',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_behance',
				'label'    => esc_html__( 'Behance', 'kubelio' ),
				'default'  => '',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_dribbble',
				'label'    => esc_html__( 'Dribbble', 'kubelio' ),
				'default'  => '',
				'section'  => $section,
			)
		);

		$this->add_field(
			array(
				'type'     => 'link',
				'settings' => 'socmed_linkedin',
				'label'    => esc_html__( 'LinkedIn', 'kubelio' ),
				'default'  => '',
				'section'  => $section,
			)
		);
	}

	public function add_share() {
		$section = 'share';

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'connect_share_facebook',
				'label'    => esc_html__( 'Facebook', 'kubelio' ),
				'section'  => $section,
				'default'  => true,
			)
		);
		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'connect_share_twitter',
				'label'    => esc_html__( 'Twitter', 'kubelio' ),
				'section'  => $section,
				'default'  => true,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'connect_share_pinterest',
				'label'    => esc_html__( 'Pinterest', 'kubelio' ),
				'section'  => $section,
				'default'  => true,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'connect_share_email',
				'label'    => esc_html__( 'Email', 'kubelio' ),
				'section'  => $section,
				'default'  => true,
			)
		);

		$this->add_field(
			array(
				'type'     => 'toggle',
				'settings' => 'connect_share_whatsapp',
				'label'    => esc_html__( 'WhatsApp', 'kubelio' ),
				'section'  => $section,
				'default'  => true,
			)
		);
	}

	// end class
}

new Connect();
