<?php

/**
 * Customizer WP methods
 *
 * @version     1.0.0
 */

namespace Retheme;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// No need to proceed if this class already exists.
class Customizer_Base {

	public $breakpoint_large  = '@media (min-width: 992px)';
	public $breakpoint_medium = '@media (max-width: 768px)';
	public $breakpoint_small  = '@media (max-width: 576px)';

	public function __construct() {
		new \Kirki\Pro\Init();
	}
	/**
	 * Add panel
	 * required kirki
	 */
	public function add_panel( $name, $args ) {
		new \Kirki\Panel( $name, $args );
	}

	/**
	 * Add section
	 * required kirki
	 */
	public function add_section( $name, $args ) {
		new \Kirki\Section( $name, $args );
	}

	/**
	 * Add field control
	 */
	public function add_field( $args ) {

		$options = $args;

		unset( $options['type'] );

		switch ( $args['type'] ) {
			case 'background':
				new \Kirki\Field\Background( $options );
				break;
			case 'color':
				new \Kirki\Field\Color( $options );
				break;
			case 'color_palette':
				new \Kirki\Field\Color_Palette( $options );
				break;
			case 'dimension':
				new \Kirki\Field\Dimension( $options );
				break;
			case 'dimensions':
				new \Kirki\Field\Dimensions( $options );
				break;
			case 'image':
				new \Kirki\Field\Image( $options );
				break;
			case 'multicheck':
				new \Kirki\Field\Multicheck( $options );
				break;
			case 'multicolor':
				new \Kirki\Field\Multicolor( $options );
				break;
			case 'number':
				new \Kirki\Field\number( $options );
				break;
			case 'radio-buttonset':
				new \Kirki\Field\Radio_Buttonset( $options );
				break;
			case 'radio-image':
				new \Kirki\Field\Radio_Image( $options );
				break;
			case 'repeater':
				new \Kirki\Field\Repeater( $options );
				break;
			case 'select':
				new \Kirki\Field\Select( $options );
				break;
			case 'slider':
				new \Kirki\Field\Slider( $options );
				break;
			case 'sortable':
				new \Kirki\Field\Sortable( $options );
				break;
			case 'toggle':
				new \Kirki\Field\Toggle( $options );
				break;
			case 'typography':
				new \Kirki\Field\Typography( $options );
				break;
			case 'upload':
				new \Kirki\Field\Upload( $options );
				break;
			case 'link':
				new \Kirki\Field\URL( $options );
				break;
			case 'url':
				new \Kirki\Field\URL( $options );
				break;
			case 'text':
				new \Kirki\Field\Text( $options );
				break;
			case 'textarea':
				new \Kirki\Field\Textarea( $options );
				break;
			case 'generic':
				new \Kirki\Field\Generic( $options );
				break;
			case 'editor':
				new \Kirki\Field\Editor( $options );
				break;
			case 'code':
				new \Kirki\Field\Code( $options );
				break;
			default:
				\Kirki::add_field( $options );
				break;
		}
	}

	/**
	 * Custom header control
	 *
	 * @param array $args
	 * @return void
	 */
	public function add_header( $args = array() ) {
		$id = uniqid();

		new \Kirki\Pro\Field\Headline(
			wp_parse_args(
				$args,
				array(
					'settings' => "control_header_{$args['section']}_{$id}",
				)
			)
		);
	}

	/**
	 * Costum divinder control
	 *
	 * @param array $args
	 * @return void
	 */
	public function add_divinder( $args = array() ) {
		$id = uniqid();

		new \Kirki\Pro\Field\Divider(
			wp_parse_args(
				$args,
				array(
					'settings' => "control_divinder_{$args['section']}_{$id}",
				)
			)
		);
	}
}

new Customizer_Base();
