<?php
/**
 * Control for logo, tagline, and browser brand
 *
 * @since 1.0.0
 */
namespace Retheme\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Brand extends \Retheme\Customizer_Base {

	public function __construct() {
		$this->add_brand_logo();
		$this->mobile_color_browser();
	}

	public function mobile_color_browser() {
		$section = 'title_tagline';

		$this->add_header(
			array(
				'label'    => esc_html__( 'Browser Theme', 'kubelio' ),
				'section'  => $section,
				'priority' => 200,
			)
		);

		$this->add_field(
			array(
				'type'        => 'color',
				'choices'     => array( 'alpha' => true ),
				'label'       => esc_html__( 'Color Browser', 'kubelio' ),
				'settings'    => 'brand_color_browser',
				'description' => esc_html__( 'Change the Color of Address Bar in Mobile Browser', 'kubelio' ),
				'section'     => $section,
				'priority'    => 210,
				'default'     => rt_get_theme( 'color' )['primary'],
			)
		);
	}

	public function add_brand_logo() {

		$section = 'title_tagline';

		// Logo Desktop
		$this->add_header(
			array(
				'label'    => esc_html__( 'Desktop Logo', 'kubelio' ),
				'section'  => $section,
				'priority' => 100,
			)
		);

		$this->add_field(
			array(
				'type'            => 'image',
				'settings'        => 'brand_logo_primary',
				'label'           => esc_html__( 'Main Logo', 'kubelio' ),
				'description'     => esc_html__( 'This logo will be used as your default logo on desktop device', 'kubelio' ),
				'section'         => $section,
				'priority'        => 120,
				'choices'         => array(
					'save_as' => 'array',
				),
				'partial_refresh' => array(
					'brand_logo_primary' => array(
						'selector'        => '.rt-logo',
						'render_callback' => '',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'slider',
				'settings'  => 'brand_logo_primary_width',
				'label'     => esc_html__( 'Main Logo Size', 'kubelio' ),
				'section'   => $section,
				'priority'  => 140,
				'choices'   => array(
					'min'  => '10',
					'max'  => '300',
					'step' => '1',
				),
				'default'   => '180',
				'output'    => array(
					array(
						'element'  => '.site-header .rt-logo',
						'property' => 'width',
						'units'    => 'px',
					),

				),
				'transport' => 'auto',
			)
		);

		// Logo Mobile
		$this->add_header(
			array(
				'label'    => esc_html__( 'Mobile Logo', 'kubelio' ),
				'section'  => $section,
				'priority' => 150,
			)
		);

		$this->add_field(
			array(
				'type'            => 'image',
				'settings'        => 'brand_logo_mobile',
				'label'           => esc_html__( 'Mobile Logo', 'kubelio' ),
				'description'     => esc_html__( 'This logo will be used on mobile devices. If it is not available, the main logo will be used.', 'kubelio' ),
				'section'         => $section,
				'priority'        => 160,
				'choices'         => array(
					'save_as' => 'array',
				),
				'partial_refresh' => array(
					'brand_logo_mobile' => array(
						'selector'        => '.rt-logo-mobile',
						'render_callback' => '',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'slider',
				'settings'  => 'brand_logo_mobile_width',
				'label'     => esc_html__( 'Mobile Logo Size', 'kubelio' ),
				'section'   => $section,
				'priority'  => 180,
				'choices'   => array(
					'min'  => '10',
					'max'  => '300',
					'step' => '1',
				),
				'default'   => '130',
				'output'    => array(
					array(
						'element'  => '.rt-logo-mobile',
						'property' => 'width',
						'units'    => 'px',
					),
				),
				'transport' => 'auto',
			)
		);

		// Logo Checkout
		$this->add_header(
			array(
				'label'    => esc_html__( 'Checkout Logo', 'kubelio' ),
				'section'  => $section,
				'priority' => 190,
			)
		);

		$this->add_field(
			array(
				'type'            => 'image',
				'settings'        => 'brand_logo_checkout',
				'label'           => esc_html__( 'Checkout Logo', 'kubelio' ),
				'description'     => esc_html__( 'This logo will be used on Checkout Focused Pages Templates. If it is not available, the main logo will be used.', 'kubelio' ),
				'section'         => $section,
				'priority'        => 195,
				'choices'         => array(
					'save_as' => 'array',
				),
				'partial_refresh' => array(
					'brand_logo_mobile' => array(
						'selector'        => '.rt-logo-checkout',
						'render_callback' => '',
					),
				),
			)
		);

		$this->add_field(
			array(
				'type'      => 'slider',
				'settings'  => 'brand_logo_checkout_width',
				'label'     => esc_html__( 'Checkout Logo Size', 'kubelio' ),
				'section'   => $section,
				'priority'  => 200,
				'choices'   => array(
					'min'  => '10',
					'max'  => '300',
					'step' => '1',
				),
				'default'   => '130',
				'output'    => array(
					array(
						'element'  => '.site-checkout-header .rt-logo',
						'property' => 'width',
						'units'    => 'px',
					),
				),
				'transport' => 'auto',
			)
		);
	}

	// end class
}

new Brand();
