<div id="modal-info-license" class="rta-modal">
	<div class="rta-modal-content">
		<div class="rta-modal-header">
			<h3><?php echo wp_sprintf( __( '%1$s License Not Activated', 'kubelio' ), esc_html( RT_THEME_NAME ) ); ?></h3>
			<div class="rta-modal-icon">
				<span class="dashicons dashicons-warning"></span>
			</div>
		</div>
		<div class="rta-modal-body">
			<div class="rt-modal-img" style="max-width: 120px;">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/license-key.webp' ); ?>" alt="Modal Info">
			</div>
			<div class="rta-modal-message">
				<p><?php echo wp_sprintf( __( 'You haven’t activated your <strong>%1$s</strong> theme license yet. Please activate your license to receive updates, premium features, and full support.', 'kubelio' ), esc_html( RT_THEME_NAME ) ); ?></p>
			</div>
		</div>
		<div class="rta-modal-footer">
			<a href="<?php echo esc_url( RT_THEME_URL ); ?>" target="_blank" class="button-link">
				<?php esc_html_e( 'Buy License', 'kubelio' ); ?>
			</a>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=theme-panel' ) ); ?>" class="button">
				<?php esc_html_e( 'Activate License', 'kubelio' ); ?>
			</a>
		</div>
	</div>
</div>

<style>
	.rta-modal {
		position: fixed;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: rgba(0, 0, 0, 0.7);
		z-index: 9999;
	}

	.rta-modal-content {
		background: #fff;
		border-radius: 8px;
		width: 90%;
		max-width: 600px;
		box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
		overflow: hidden;
		margin: 180px auto 0;
	}

	.rta-modal-header {
		background: #f8f9fa;
		padding: 15px 20px;
		border-bottom: 1px solid #e9ecef;
		display: flex;
		justify-content: space-between;
		align-items: center;
	}

	.rta-modal-header h3 {
		margin: 0;
		font-size: 16px;
		color: #1d2327;
	}

	.rta-modal-close {
		background: none;
		border: none;
		font-size: 24px;
		cursor: pointer;
		color: #646970;
		padding: 0 5px;
	}

	.rta-modal-body {
		padding: 25px 20px;
		display: flex;
		align-items: center;
		gap: 20px;
	}

	.rta-modal-icon .dashicons {
		font-size: 28px;
		width: 28px;
		height: 28px;
		color: #dba617;
	}

	.rta-modal-message p {
		margin: 0;
		color: #646970;
		line-height: 1.5;
	}

	.rta-modal-footer {
		padding: 15px 20px;
		background: #f8f9fa;
		border-top: 1px solid #e9ecef;
		text-align: right;
	}

	.rta-modal-footer .button {
		margin-left: 10px;
		background-color: #2271b1;
		font-size: 14px;
		color: #fff;
	}

	.rta-modal-footer .button-link {
		color: #2271b1;
		font-size: 14px;
	}

	@media (max-width: 480px) {
		.rta-modal-body {
			flex-direction: column;
			align-items: center;
			text-align: center;
		}

		.rta-modal-content {
			margin: 80px auto 0;
		}

		.rta-modal-footer {
			text-align: center;
		}
	}
</style>