<div class="rta">
	<div class="rta-container">

		<div class="rta-panel rta-panel-wizard">
			<div class="rta-panel__header">
				<h3 class="rta-panel__title"><?php esc_html_e( 'Theme Setup Wizard', 'kubelio' ); ?></h3>
			</div>
			<div class="rta-panel__body">
				<div class="rta-wizard-info" style="display: flex; gap: 40px; flex-flow: row wrap; align-items: center;">

					<div class="rta-is-layout-flow" style="flex: 1">
						<p><?php esc_html_e( 'A guided setup process to install required plugins and import demo content with ease. You will get the exact same look as the demo website, so you only need to edit the content according to your needs.', 'kubelio' ); ?></p>
						<div class="rta-panel__action">
							<a href="<?php echo esc_url( admin_url( 'admin.php?page=merlin' ) ); ?>" class="button-primary"><?php esc_html_e( 'Get Started', 'kubelio' ); ?></a>
						</div>
					</div>

					<div style="flex: 1; max-width: 230px; padding: 20px;">
						<img style="width: 100%; height: auto;" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/setup-wizard.webp' ); ?>" alt="<?php echo esc_attr__( 'Setup Wizard', 'kubelio' ); ?>">
					</div>

				</div>
			</div>
		</div>

		<div class="rta-grids" style="--grid-columns-size: 300px">
			<div class="rta-panel">
				<div class="rta-panel__header">
					<h3 class="rta-panel__title"><?php esc_html_e( 'Knowledge Base', 'kubelio' ); ?></h3>
				</div>
				<div class="rta-panel__body rta-is-layout-flow">
					<p><?php esc_html_e( 'A collection of guides and documentation to help you understand theme features, settings, and customization options.', 'kubelio' ); ?></p>
					<div class="rta-panel__action">
						<a href="<?php echo esc_url( RT_THEME_DOC ); ?>" target="_blank" class="button"><?php esc_html_e( 'View Tutorials', 'kubelio' ); ?></a>
					</div>
				</div>
			</div>
			<div class="rta-panel">
				<div class="rta-panel__header">
					<h3 class="rta-panel__title"><?php esc_html_e( 'Support', 'kubelio' ); ?></h3>
				</div>
				<div class="rta-panel__body rta-is-layout-flow">
					<p><?php esc_html_e( 'Get help and assistance for any issues, questions, or customization needs related to your theme.', 'kubelio' ); ?></p>

					<div class="rta-panel__action">
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=theme-panel-contact' ) ); ?>" class="button"><?php esc_html_e( 'Get Support', 'kubelio' ); ?></a>
					</div>
				</div>
			</div>
			<div class="rta-panel">
				<div class="rta-panel__header">
					<h3 class="rta-panel__title"><?php esc_html_e( 'Customize', 'kubelio' ); ?></h3>
				</div>
				<div class="rta-panel__body rta-is-layout-flow">
					<p><?php esc_html_e( 'Modify theme settings such as logo, colors, fonts, layouts, and other design options directly from the WordPress Customizer.', 'kubelio' ); ?></p>
					<div class="rta-panel__action">
						<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button"><?php esc_html_e( 'Open Customizer', 'kubelio' ); ?></a>
					</div>
				</div>
			</div>


			<?php if ( rt_admin_check_all_plugins_active() === false ) : ?>
				<div class="rta-panel">
					<div class="rta-panel__header">
						<h3 class="rta-panel__title"><?php esc_html_e( 'Install Plugins', 'kubelio' ); ?></h3>
					</div>
					<div class="rta-panel__body rta-is-layout-flow">
						<p><?php esc_html_e( 'Install and activate the required or recommended plugins to ensure full theme functionality.', 'kubelio' ); ?></p>
						<div class="rta-panel__action">
							<a href="<?php echo esc_url( admin_url( 'admin.php?page=tgmpa-install-plugins' ) ); ?>" class="button"><?php esc_html_e( 'Install Now', 'kubelio' ); ?></a>
						</div>
					</div>
				</div>
			<?php endif; ?>

		</div>

	</div>
</div>