<?php

/**
 * Admin functions
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Admin enqueue script
 *
 * @since 1.0.0
 */
function rt_admin_enqueue_scripts() {
	wp_enqueue_style( 'retheme-admin', get_template_directory_uri() . '/assets/css/admin.min.css', array(), '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'rt_admin_enqueue_scripts' );

/**
 * Register Theme Panel menu and submenus
 */
function rt_admin_add_menu_panel() {
	// Main menu
	add_menu_page(
		esc_html__( 'Theme Panel', 'kubelio' ),
		esc_html__( 'Theme Panel', 'kubelio' ),
		'manage_options',
		'theme-panel',
		'',
		'dashicons-admin-generic',
		999
	);

	// Dashboard submenu
	add_submenu_page(
		'theme-panel',
		esc_html__( 'Dashboard', 'kubelio' ),
		esc_html__( 'Dashboard', 'kubelio' ),
		'manage_options',
		'theme-panel',
		function () {
			get_template_part( 'core/admin/dashboard' );
		},
		1
	);

	// Setup merlin submenu
	add_submenu_page(
		'theme-panel',
		esc_html__( 'Theme Setup', 'kubelio' ),
		esc_html__( 'Setup Wizard', 'kubelio' ),
		'manage_options',
		'theme-setup',
		'__return_false',
		2
	);

	// Customizer submenu
	add_submenu_page(
		'theme-panel',
		esc_html__( 'Customize', 'kubelio' ),
		esc_html__( 'Customize', 'kubelio' ),
		'manage_options',
		'theme-customizer',
		'__return_false',
		3
	);
}
add_action( 'admin_menu', 'rt_admin_add_menu_panel' );

/**
 * Redirect Theme Setup submenu to Merlin WP
 */
function rt_admin_redirect_menu() {

	// Redirect Theme Setup submenu to Merlin WP
	if ( isset( $_GET['page'] ) && $_GET['page'] === 'theme-setup' ) {
		wp_safe_redirect( admin_url( 'themes.php?page=merlin' ) );
		exit;
	}

	// Redirect Theme Customizer submenu to Customizer
	if ( isset( $_GET['page'] ) && $_GET['page'] === 'theme-customizer' ) {
		wp_safe_redirect( admin_url( 'customize.php' ) );
		exit;
	}
}
add_action( 'admin_init', 'rt_admin_redirect_menu' );

/**
 * TGMPA Check All Plugins Active
 *
 * @since 1.0.0
 * @return bool
 */
function rt_admin_check_all_plugins_active() {
	// Check if TGMPA is active
	if ( ! class_exists( 'TGM_Plugin_Activation' ) ) {
		return false;
	}

	$tgmpa      = TGM_Plugin_Activation::get_instance();
	$all_active = true;

	foreach ( $tgmpa->plugins as $slug => $plugin ) {
		if ( ! $tgmpa->is_plugin_active( $slug ) ) {
			$all_active = false;
			break;
		}
	}

	return $all_active;
}

// /**
// * Admin license key notice
// *
// * @since 1.0.0
// */
// function rt_admin_license_key_notice() {
// if ( current_user_can( 'manage_options' ) && !rt_fs()->can_use_premium_code() ) {
// get_template_part( 'core/admin/admin-info' );
// }
// }
// add_action( 'admin_notices', 'rt_admin_license_key_notice', 99 );

// /**
// * Modal lincense notice
// */
// function rt_admin_license_modal_info() {
// if ( current_user_can( 'manage_options' ) && !rt_fs()->can_use_premium_code() ) {
// get_template_part( 'core/admin/modal-info' );
// }
// }
// add_action( 'wp_footer', 'rt_admin_license_modal_info' );

// /**
// * Change annual option in monthly plan
// */
// rt_fs()->add_filter( 'pricing/show_annual_in_monthly', '__return_false' );
