<div class="notice notice-warning">
	<div class="rta-info">
		<div class="rta-info__image">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/license-key.webp' ); ?>" alt="<?php echo esc_attr( RT_THEME_NAME ); ?>">
		</div>
		<div class="rta-info__content">
			<h3 class="rta-info__title">
				<?php echo wp_sprintf( esc_html__( '%s License Not Activated', 'kubelio' ), RT_THEME_NAME ); ?>
			</h3>
			<p>
				<?php
				echo wp_sprintf(
					wp_kses_post( __( 'You haven\'t activated your <strong>%s</strong> theme license yet. Please activate your license to receive updates, premium features, and full support.', 'kubelio' ) ),
					RT_THEME_NAME
				);
				?>
			</p>
			<div class="rta-info__action">
				<a href="<?php echo esc_url( RT_THEME_URL ); ?>" class="button" target="_blank">
					<?php esc_html_e( 'Buy License', 'kubelio' ); ?>
				</a>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=theme-panel' ) ); ?>" class="button button-primary">
					<?php esc_html_e( 'Activate License', 'kubelio' ); ?>
				</a>
			</div>
		</div>
	</div>
</div>