<?php

/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package theme
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div class="rt-block-heading">
	<h2 class="rt-block-heading__title has-medium-font-size">
		<?php
		echo esc_html(
			_n(
				'Comment',
				'Comments',
				get_comments_number(),
				'kubelio'
			)
		);
		?>
	</h2>
</div>

<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>

		<?php if ( wp_list_comments( array( 'echo' => false ) ) ) : ?>
			<ol class="comment-list">
				<?php
				wp_list_comments(
					array(
						'style'      => 'ol',
						'short_ping' => true,
					)
				);
				?>
			</ol>
		<?php endif ?>

		<?php if ( paginate_comments_links( array( 'echo' => false ) ) ) : ?>
			<div class="rt-pagination">
				<?php
				paginate_comments_links(
					array(
						'prev_text' => '<i class="rt-icon"><svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/></svg></i>',
						'next_text' => '<i class="rt-icon"><svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/></svg></i>',
					)
				);
				?>
			</div>
		<?php endif ?>


		<?php if ( ! comments_open() ) : ?>
			<p class="no-comments"><?php echo esc_html__( 'Comments are closed.', 'kubelio' ); ?></p>
		<?php endif ?>

	<?php endif; ?>

	<?php comment_form(); ?>

</div>